package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * Base input trust interface for handlers that verify the trust of the request. Do not confuse trust and authorization.
 *
 * Trusted input by means of <code>Cross-Site Request Forgery</code> as an example, gives the application guarantees about
 * the integrity of the data. It does not replace proper {@link io.vertx.mutiny.ext.web.handler.AuthorizationHandler} checks.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.InputTrustHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.InputTrustHandler.class)
public interface InputTrustHandler extends io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  io.vertx.ext.web.handler.InputTrustHandler getDelegate();

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0);

  default public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  InputTrustHandler newInstance(io.vertx.ext.web.handler.InputTrustHandler arg) {
    return arg != null ? new InputTrustHandlerImpl(arg) : null;
  }

}

class InputTrustHandlerImpl implements InputTrustHandler {
  private final io.vertx.ext.web.handler.InputTrustHandler delegate;
  
  public io.vertx.ext.web.handler.InputTrustHandler getDelegate() {
    return delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  InputTrustHandlerImpl() {
    this.delegate = null;
  }

  public InputTrustHandlerImpl(io.vertx.ext.web.handler.InputTrustHandler delegate) {
    this.delegate = delegate;
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

}
