package io.vertx.mutiny.ext.web;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Map;

/**
 * A parsed language header.
 * Delivers a more direct access to the individual elements of the header it represents
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.LanguageHeader original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.LanguageHeader.class)
public class LanguageHeader implements io.vertx.mutiny.ext.web.ParsedHeaderValue {

  public static final io.smallrye.mutiny.vertx.TypeArg<LanguageHeader> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new LanguageHeader((io.vertx.ext.web.LanguageHeader) obj),
    LanguageHeader::getDelegate
  );

  private final io.vertx.ext.web.LanguageHeader delegate;
  
  public LanguageHeader(io.vertx.ext.web.LanguageHeader delegate) {
    this.delegate = delegate;
  }

  public LanguageHeader(Object delegate) {
    this.delegate = (io.vertx.ext.web.LanguageHeader)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  LanguageHeader() {
    this.delegate = null;
  }

  public io.vertx.ext.web.LanguageHeader getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    LanguageHeader that = (LanguageHeader) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return 
   */
  public String rawValue() { 
    String ret = delegate.rawValue();
    return ret;
  }

  /**
   * @return 
   */
  public String value() { 
    String ret = delegate.value();
    return ret;
  }

  /**
   * @return 
   */
  public float weight() { 
    float ret = delegate.weight();
    return ret;
  }

  /**
   * @param key 
   * @return 
   */
  public String parameter(String key) { 
    String ret = delegate.parameter(key);
    return ret;
  }

  /**
   * @return Unmodifiable Map of parameters of this header value
   */
  public java.util.Map<String, String> parameters() { 
    java.util.Map<String, String> ret = delegate.parameters();
    return ret;
  }

  /**
   * @return 
   */
  public boolean isPermitted() { 
    boolean ret = delegate.isPermitted();
    return ret;
  }

  /**
   * @param matchTry The header to be matched from
   * @return true if this header represents a subset of matchTry, otherwise, false
   */
  public boolean isMatchedBy(io.vertx.mutiny.ext.web.ParsedHeaderValue matchTry) { 
    boolean ret = delegate.isMatchedBy(matchTry.getDelegate());
    return ret;
  }

  /**
   * @return 
   */
  public int weightedOrder() { 
    int ret = delegate.weightedOrder();
    return ret;
  }

  /**
   * @return The language tag
   */
  public String tag() { 
    String ret = delegate.tag();
    return ret;
  }

  /**
   * @return The language subtag
   */
  public String subtag() { 
    String ret = delegate.subtag();
    return ret;
  }

  /**
   * @param level 
   * @return The language subtag at specified position
   */
  public String subtag(int level) { 
    String ret = delegate.subtag(level);
    return ret;
  }

  /**
   * @return the number of subtags this value has
   */
  public int subtagCount() { 
    int ret = delegate.subtagCount();
    return ret;
  }

  /**
   * <quote>If no "q" parameter is present, the default weight is 1.</quote>
   */
  public static final float DEFAULT_WEIGHT = io.vertx.ext.web.LanguageHeader.DEFAULT_WEIGHT;
  public static  LanguageHeader newInstance(io.vertx.ext.web.LanguageHeader arg) {
    return arg != null ? new LanguageHeader(arg) : null;
  }

}
