package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;

/**
 * The X-Frame-Options HTTP response header can be used to indicate whether or not a browser should be allowed to render
 * a page in a <code><frame></code>, <code><iframe></code>, <code><embed></code> or <code><object></code>. Sites can use this to avoid
 * click-jacking attacks, by ensuring that their content is not embedded into other sites.
 *
 * The added security is provided only if the user accessing the document is using a browser that supports
 * <code>X-Frame-Options</code>.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.XFrameHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.XFrameHandler.class)
public class XFrameHandler implements io.vertx.mutiny.ext.web.handler.SecurityPolicyHandler, io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<XFrameHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new XFrameHandler((io.vertx.ext.web.handler.XFrameHandler) obj),
    XFrameHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.XFrameHandler delegate;
  
  public XFrameHandler(io.vertx.ext.web.handler.XFrameHandler delegate) {
    this.delegate = delegate;
  }

  public XFrameHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.XFrameHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  XFrameHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.XFrameHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    XFrameHandler that = (XFrameHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param action a string value either <code>DENY</code> or <code>SAMEORIGIN</code>.
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.XFrameHandler create(String action) { 
    io.vertx.mutiny.ext.web.handler.XFrameHandler ret = io.vertx.mutiny.ext.web.handler.XFrameHandler.newInstance((io.vertx.ext.web.handler.XFrameHandler)io.vertx.ext.web.handler.XFrameHandler.create(action));
    return ret;
  }

  /**
   * The page cannot be displayed in a frame, regardless of the site attempting to do so.
   */
  public static final String DENY = io.vertx.ext.web.handler.XFrameHandler.DENY;
  /**
   * The page can only be displayed in a frame on the same origin as the page itself. The spec leaves it up to browser
   * vendors to decide whether this option applies to the top level, the parent, or the whole chain, although it is
   * argued that the option is not very useful unless all ancestors are also in the same origin.
   */
  public static final String SAMEORIGIN = io.vertx.ext.web.handler.XFrameHandler.SAMEORIGIN;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  XFrameHandler newInstance(io.vertx.ext.web.handler.XFrameHandler arg) {
    return arg != null ? new XFrameHandler(arg) : null;
  }

}
