package io.vertx.mutiny.ext.web;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import java.util.Map;
import java.util.function.Function;

/**
 * Represents a browser session.
 * <p>
 * Sessions persist between HTTP requests for a single browser session. They are deleted when the browser is closed, or
 * they time-out. Session cookies are used to maintain sessions using a secure UUID.
 * <p>
 * Sessions can be used to maintain data for a browser session, e.g. a shopping basket.
 * <p>
 * The context must have first been routed to a {@link io.vertx.mutiny.ext.web.handler.SessionHandler}
 * for sessions to be available.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.Session original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.Session.class)
public class Session implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Session> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Session((io.vertx.ext.web.Session) obj),
    Session::getDelegate
  );

  private final io.vertx.ext.web.Session delegate;
  
  public Session(io.vertx.ext.web.Session delegate) {
    this.delegate = delegate;
  }

  public Session(Object delegate) {
    this.delegate = (io.vertx.ext.web.Session)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Session() {
    this.delegate = null;
  }

  @Override
  public io.vertx.ext.web.Session getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Session that = (Session) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return The new unique ID of the session.
   */
  public io.vertx.mutiny.ext.web.Session regenerateId() { 
    io.vertx.mutiny.ext.web.Session ret = io.vertx.mutiny.ext.web.Session.newInstance((io.vertx.ext.web.Session)delegate.regenerateId());
    return ret;
  }

  /**
   * @return The unique ID of the session. This is generated using a random secure UUID.
   */
  public String id() { 
    String ret = delegate.id();
    return ret;
  }

  /**
   * @param key the key for the data
   * @param obj the data
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.Session put(String key, java.lang.Object obj) { 
    delegate.put(key, obj);
    return this;
  }

  /**
   * @param key the key for the data
   * @param obj the data
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.Session putIfAbsent(String key, java.lang.Object obj) { 
    delegate.putIfAbsent(key, obj);
    return this;
  }

  /**
   * @param key the key for the data
   * @param mappingFunction a mapping function
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.ext.web.Session computeIfAbsent(String key, Function<String, java.lang.Object> mappingFunction) { 
    delegate.computeIfAbsent(key, mappingFunction);
    return this;
  }

  /**
   * @param key the key of the data
   * @return the data
   */
  public <T> T get(String key) { 
    T ret = (T) delegate.get(key);
    return ret;
  }

  /**
   * @param key the key of the data
   * @return the data that was there or null if none there
   */
  public <T> T remove(String key) { 
    T ret = (T) delegate.remove(key);
    return ret;
  }

  /**
   * @return true if the session has data
   */
  public boolean isEmpty() { 
    boolean ret = delegate.isEmpty();
    return ret;
  }

  /**
   * @return the time the session was last accessed
   */
  public long lastAccessed() { 
    long ret = delegate.lastAccessed();
    return ret;
  }

  /**
   */
  public void destroy() { 
    delegate.destroy();
  }

  /**
   * @return has the session been destroyed?
   */
  public boolean isDestroyed() { 
    boolean ret = delegate.isDestroyed();
    return ret;
  }

  /**
   * @return has the session been renewed?
   */
  public boolean isRegenerated() { 
    boolean ret = delegate.isRegenerated();
    return ret;
  }

  /**
   * @return old ID if renewed
   */
  public String oldId() { 
    String ret = delegate.oldId();
    return ret;
  }

  /**
   * @return the amount of time in ms, after which the session will expire, if not accessed.
   */
  public long timeout() { 
    long ret = delegate.timeout();
    return ret;
  }

  /**
   */
  public void setAccessed() { 
    delegate.setAccessed();
  }

  /**
   * @return short representation string.
   */
  public String value() { 
    String ret = delegate.value();
    return ret;
  }

  /**
   * @return the session data as a map
   */
  public java.util.Map<String, java.lang.Object> data() { 
    java.util.Map<String, java.lang.Object> ret = delegate.data();
    return ret;
  }

  public static  Session newInstance(io.vertx.ext.web.Session arg) {
    return arg != null ? new Session(arg) : null;
  }

}
