package io.vertx.mutiny.ext.web.handler;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.Handler;

/**
 * A pretty error handler for rendering error pages. When working in development mode
 * exception details will be returned in the server responses, otherwise or when
 * manually specified no exception details are returned in the HTTP response.
 *
 * The reason the display of the exception details is by default dependent of the mode
 * is to follow the security best practices:
 * <a href="https://www.owasp.org/index.php/Improper_Error_Handling">https://www.owasp.org/index.php/Improper_Error_Handling</a>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.handler.ErrorHandler original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.ext.web.handler.ErrorHandler.class)
public class ErrorHandler implements io.vertx.core.Handler<io.vertx.mutiny.ext.web.RoutingContext>, java.util.function.Consumer<io.vertx.mutiny.ext.web.RoutingContext> {

  public static final io.smallrye.mutiny.vertx.TypeArg<ErrorHandler> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new ErrorHandler((io.vertx.ext.web.handler.ErrorHandler) obj),
    ErrorHandler::getDelegate
  );

  private final io.vertx.ext.web.handler.ErrorHandler delegate;
  
  public ErrorHandler(io.vertx.ext.web.handler.ErrorHandler delegate) {
    this.delegate = delegate;
  }

  public ErrorHandler(Object delegate) {
    this.delegate = (io.vertx.ext.web.handler.ErrorHandler)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  ErrorHandler() {
    this.delegate = null;
  }

  public io.vertx.ext.web.handler.ErrorHandler getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ErrorHandler that = (ErrorHandler) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public void handle(io.vertx.mutiny.ext.web.RoutingContext arg0) { 
    delegate.handle(arg0.getDelegate());
  }

  /**
   * @param vertx 
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.ErrorHandler create(io.vertx.mutiny.core.Vertx vertx) { 
    io.vertx.mutiny.ext.web.handler.ErrorHandler ret = io.vertx.mutiny.ext.web.handler.ErrorHandler.newInstance((io.vertx.ext.web.handler.ErrorHandler)io.vertx.ext.web.handler.ErrorHandler.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * @param vertx 
   * @param errorTemplateName the error template name - will be looked up from the classpath
   * @param displayExceptionDetails true if exception details should be displayed
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.ErrorHandler create(io.vertx.mutiny.core.Vertx vertx, String errorTemplateName, boolean displayExceptionDetails) { 
    io.vertx.mutiny.ext.web.handler.ErrorHandler ret = io.vertx.mutiny.ext.web.handler.ErrorHandler.newInstance((io.vertx.ext.web.handler.ErrorHandler)io.vertx.ext.web.handler.ErrorHandler.create(vertx.getDelegate(), errorTemplateName, displayExceptionDetails));
    return ret;
  }

  /**
   * @param vertx 
   * @param displayExceptionDetails true if exception details should be displayed
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.ErrorHandler create(io.vertx.mutiny.core.Vertx vertx, boolean displayExceptionDetails) { 
    io.vertx.mutiny.ext.web.handler.ErrorHandler ret = io.vertx.mutiny.ext.web.handler.ErrorHandler.newInstance((io.vertx.ext.web.handler.ErrorHandler)io.vertx.ext.web.handler.ErrorHandler.create(vertx.getDelegate(), displayExceptionDetails));
    return ret;
  }

  /**
   * @param vertx 
   * @param errorTemplateName the error template name - will be looked up from the classpath
   * @return the handler
   */
  public static io.vertx.mutiny.ext.web.handler.ErrorHandler create(io.vertx.mutiny.core.Vertx vertx, String errorTemplateName) { 
    io.vertx.mutiny.ext.web.handler.ErrorHandler ret = io.vertx.mutiny.ext.web.handler.ErrorHandler.newInstance((io.vertx.ext.web.handler.ErrorHandler)io.vertx.ext.web.handler.ErrorHandler.create(vertx.getDelegate(), errorTemplateName));
    return ret;
  }

  /**
   * The default template to use for rendering
   */
  public static final String DEFAULT_ERROR_HANDLER_TEMPLATE = io.vertx.ext.web.handler.ErrorHandler.DEFAULT_ERROR_HANDLER_TEMPLATE;
  public void accept(io.vertx.mutiny.ext.web.RoutingContext item) {
    handle(item);
  }
  public static  ErrorHandler newInstance(io.vertx.ext.web.handler.ErrorHandler arg) {
    return arg != null ? new ErrorHandler(arg) : null;
  }

}
