/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.reactor;

import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class FluxConverter
implements ReactiveTypeConverter<Flux> {
    public <X> CompletionStage<X> toCompletionStage(Flux instance) {
        return instance.take(1L).singleOrEmpty().toFuture();
    }

    public <X> Publisher<X> toRSPublisher(Flux instance) {
        return instance;
    }

    public <X> Flow.Publisher<X> toFlowPublisher(Flux instance) {
        return AdaptersToFlow.publisher((Publisher)instance);
    }

    public <X> Flux fromCompletionStage(CompletionStage<X> cs) {
        return Flux.create(sink -> cs.whenComplete((v, e) -> {
            if (e != null) {
                sink.error(e instanceof CompletionException ? e.getCause() : e);
            } else if (v != null) {
                sink.next(v);
                sink.complete();
            } else {
                sink.complete();
            }
        }));
    }

    public <X> Flux fromPublisher(Publisher<X> publisher) {
        return Flux.from(publisher);
    }

    public <X> Flux fromFlowPublisher(Flow.Publisher<X> publisher) {
        return Flux.from((Publisher)AdaptersToReactiveStreams.publisher(publisher));
    }

    public Class<Flux> type() {
        return Flux.class;
    }

    public boolean emitItems() {
        return true;
    }

    public boolean emitAtMostOneItem() {
        return false;
    }

    public boolean supportNullValue() {
        return false;
    }
}

