/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.reactor;

import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class MonoConverter
implements ReactiveTypeConverter<Mono> {
    public <X> CompletionStage<X> toCompletionStage(Mono instance) {
        return instance.toFuture();
    }

    public <X> Publisher<X> toRSPublisher(Mono instance) {
        return instance;
    }

    public <X> Flow.Publisher<X> toFlowPublisher(Mono instance) {
        return AdaptersToFlow.publisher((Publisher)instance);
    }

    public <X> Mono fromCompletionStage(CompletionStage<X> cs) {
        return Mono.create(sink -> cs.whenComplete((v, e) -> {
            if (e != null) {
                sink.error(e instanceof CompletionException ? e.getCause() : e);
            } else if (v != null) {
                sink.success(v);
            } else {
                sink.success();
            }
        }));
    }

    public <X> Mono fromPublisher(Publisher<X> publisher) {
        return Mono.from(publisher);
    }

    public <X> Mono fromFlowPublisher(Flow.Publisher<X> publisher) {
        return Mono.from((Publisher)AdaptersToReactiveStreams.publisher(publisher));
    }

    public Class<Mono> type() {
        return Mono.class;
    }

    public boolean emitItems() {
        return true;
    }

    public boolean emitAtMostOneItem() {
        return true;
    }

    public boolean supportNullValue() {
        return false;
    }
}

