/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.rxjava2;

import io.reactivex.Emitter;
import io.reactivex.Flowable;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import io.smallrye.reactive.converters.rxjava2.ObservableConverter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public class FlowableConverter
implements ReactiveTypeConverter<Flowable> {
    public <T> Publisher<T> toRSPublisher(Flowable instance) {
        return instance;
    }

    public Flowable fromPublisher(Publisher publisher) {
        if (publisher instanceof Flowable) {
            return (Flowable)publisher;
        }
        return Flowable.fromPublisher((Publisher)publisher);
    }

    public <T> CompletionStage<T> toCompletionStage(Flowable instance) {
        CompletableFuture future = new CompletableFuture();
        instance.firstElement().subscribe(future::complete, future::completeExceptionally, () -> future.complete(null));
        return future;
    }

    public <X> Flowable fromCompletionStage(CompletionStage<X> cs) {
        return Flowable.generate(emitter -> ObservableConverter.toStreamEvents(cs, (Emitter<Object>)emitter));
    }

    public Class<Flowable> type() {
        return Flowable.class;
    }

    public boolean emitItems() {
        return true;
    }

    public boolean emitAtMostOneItem() {
        return false;
    }

    public boolean supportNullValue() {
        return false;
    }
}

