/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.rxjava2;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.reactivestreams.Publisher;

public class FlowableConverter
implements ReactiveTypeConverter<Flowable> {
    public <T> Publisher<T> toRSPublisher(Flowable instance) {
        return instance;
    }

    public <X> Flow.Publisher<X> toFlowPublisher(Flowable instance) {
        return AdaptersToFlow.publisher((Publisher)instance);
    }

    public Flowable fromPublisher(Publisher publisher) {
        if (publisher instanceof Flowable) {
            return (Flowable)publisher;
        }
        return Flowable.fromPublisher((Publisher)publisher);
    }

    public <T> CompletionStage<T> toCompletionStage(Flowable instance) {
        CompletableFuture future = new CompletableFuture();
        instance.firstElement().subscribe(future::complete, future::completeExceptionally, () -> future.complete(null));
        return future;
    }

    public <X> Flowable fromCompletionStage(CompletionStage<X> cs) {
        return Flowable.create(emitter -> cs.whenComplete((res, err) -> {
            if (res != null) {
                emitter.onNext(res);
                emitter.onComplete();
            } else if (err != null) {
                emitter.onError(err instanceof CompletionException ? err.getCause() : err);
            } else {
                emitter.onComplete();
            }
        }), (BackpressureStrategy)BackpressureStrategy.BUFFER);
    }

    public <X> Flowable fromFlowPublisher(Flow.Publisher<X> publisher) {
        return this.fromPublisher(AdaptersToReactiveStreams.publisher(publisher));
    }

    public Class<Flowable> type() {
        return Flowable.class;
    }

    public boolean emitItems() {
        return true;
    }

    public boolean emitAtMostOneItem() {
        return false;
    }

    public boolean supportNullValue() {
        return false;
    }
}

