/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.rxjava2;

import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.reactivestreams.Publisher;

public class MaybeConverter
implements ReactiveTypeConverter<Maybe> {
    public <T> CompletionStage<T> toCompletionStage(Maybe instance) {
        CompletableFuture future = new CompletableFuture();
        Maybe s = Objects.requireNonNull(instance);
        s.subscribe(future::complete, future::completeExceptionally, () -> future.complete(null));
        return future;
    }

    public Maybe fromCompletionStage(CompletionStage cs) {
        CompletionStage future = Objects.requireNonNull(cs);
        return Maybe.create(emitter -> future.whenComplete((res, err) -> {
            if (emitter.isDisposed()) {
                return;
            }
            if (err != null) {
                emitter.onError(err instanceof CompletionException ? err.getCause() : err);
            } else if (res == null) {
                emitter.onComplete();
            } else if (res instanceof Optional) {
                this.manageOptional(emitter, (Optional)res);
            } else {
                emitter.onSuccess(res);
            }
        }));
    }

    private <T> void manageOptional(MaybeEmitter<T> emitter, Optional<T> optional) {
        if (optional.isPresent()) {
            emitter.onSuccess(optional.get());
        } else {
            emitter.onComplete();
        }
    }

    public <X> Publisher<X> toRSPublisher(Maybe instance) {
        return instance.toFlowable();
    }

    public <X> Flow.Publisher<X> toFlowPublisher(Maybe instance) {
        return AdaptersToFlow.publisher((Publisher)instance.toFlowable());
    }

    public <X> Maybe fromPublisher(Publisher<X> publisher) {
        return Flowable.fromPublisher(publisher).firstElement();
    }

    public <X> Maybe fromFlowPublisher(Flow.Publisher<X> publisher) {
        return this.fromPublisher((Publisher<X>)AdaptersToReactiveStreams.publisher(publisher));
    }

    public Class<Maybe> type() {
        return Maybe.class;
    }

    public boolean emitItems() {
        return true;
    }

    public boolean emitAtMostOneItem() {
        return true;
    }

    public boolean supportNullValue() {
        return false;
    }
}

