/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.rxjava2;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Emitter;
import io.reactivex.Observable;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.reactivestreams.Publisher;

public class ObservableConverter
implements ReactiveTypeConverter<Observable> {
    static <X> void toStreamEvents(CompletionStage<X> cs, Emitter<Object> emitter) {
        cs.whenComplete((res, err) -> {
            if (res != null) {
                emitter.onNext(res);
                emitter.onComplete();
            } else if (err != null) {
                emitter.onError(err instanceof CompletionException ? err.getCause() : err);
            } else {
                emitter.onComplete();
            }
        });
    }

    public <T> Publisher<T> toRSPublisher(Observable instance) {
        return instance.toFlowable(BackpressureStrategy.MISSING);
    }

    public <X> Flow.Publisher<X> toFlowPublisher(Observable instance) {
        return AdaptersToFlow.publisher(this.toRSPublisher(instance));
    }

    public Observable fromPublisher(Publisher publisher) {
        return Observable.fromPublisher((Publisher)publisher);
    }

    public <T> CompletionStage<T> toCompletionStage(Observable instance) {
        CompletableFuture future = new CompletableFuture();
        instance.firstElement().subscribe(future::complete, future::completeExceptionally, () -> future.complete(null));
        return future;
    }

    public <X> Observable fromCompletionStage(CompletionStage<X> cs) {
        return Observable.create(emitter -> ObservableConverter.toStreamEvents(cs, (Emitter<Object>)emitter));
    }

    public <X> Observable fromFlowPublisher(Flow.Publisher<X> publisher) {
        return this.fromPublisher(AdaptersToReactiveStreams.publisher(publisher));
    }

    public Class<Observable> type() {
        return Observable.class;
    }

    public boolean emitItems() {
        return true;
    }

    public boolean emitAtMostOneItem() {
        return false;
    }

    public boolean supportNullValue() {
        return false;
    }
}

