/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.converters.rxjava2;

import io.reactivex.Flowable;
import io.reactivex.Single;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.AdaptersToFlow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.reactivestreams.Publisher;

public class SingleConverter
implements ReactiveTypeConverter<Single> {
    public <T> CompletionStage<T> toCompletionStage(Single instance) {
        CompletableFuture future = new CompletableFuture();
        Single s = Objects.requireNonNull(instance);
        s.subscribe(future::complete, future::completeExceptionally);
        return future;
    }

    public <X> Publisher<X> toRSPublisher(Single instance) {
        return instance.toFlowable();
    }

    public <X> Flow.Publisher<X> toFlowPublisher(Single instance) {
        return AdaptersToFlow.publisher(this.toRSPublisher(instance));
    }

    public <X> Single<X> fromCompletionStage(CompletionStage<X> cs) {
        CompletionStage future = Objects.requireNonNull(cs);
        return Single.create(emitter -> future.whenComplete((res, err) -> {
            if (!emitter.isDisposed()) {
                if (err != null) {
                    emitter.onError(err instanceof CompletionException ? err.getCause() : err);
                } else {
                    emitter.onSuccess(res);
                }
            }
        }));
    }

    public <X> Single fromPublisher(Publisher<X> publisher) {
        return Flowable.fromPublisher(publisher).firstOrError();
    }

    public <X> Single fromFlowPublisher(Flow.Publisher<X> publisher) {
        return this.fromPublisher((Publisher<X>)AdaptersToReactiveStreams.publisher(publisher));
    }

    public Class<Single> type() {
        return Single.class;
    }

    public boolean emitItems() {
        return true;
    }

    public boolean emitAtMostOneItem() {
        return true;
    }

    public boolean supportNullValue() {
        return false;
    }

    public boolean requireAtLeastOneItem() {
        return true;
    }
}

