/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.vertx.amqp.impl.AmqpMessageImpl;
import io.vertx.axle.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.proton.ProtonHelper;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.MessageError;
import org.eclipse.microprofile.reactive.messaging.Message;

public class AmqpMessage<T>
implements Message<T> {
    private final io.vertx.amqp.AmqpMessage message;
    private final boolean received;

    public AmqpMessage(io.vertx.axle.amqp.AmqpMessage delegate) {
        this.message = delegate.getDelegate();
        this.received = true;
    }

    public AmqpMessage(T payload) {
        org.apache.qpid.proton.message.Message msg = ProtonHelper.message();
        if (payload instanceof Section) {
            msg.setBody((Section)payload);
        } else {
            msg.setBody((Section)new AmqpValue(payload));
        }
        this.message = new AmqpMessageImpl(msg);
        this.received = false;
    }

    public AmqpMessage(io.vertx.amqp.AmqpMessage msg) {
        this.message = msg;
        this.received = false;
    }

    public CompletionStage<Void> ack() {
        if (this.received) {
            this.message.accepted();
        }
        return CompletableFuture.completedFuture(null);
    }

    public T getPayload() {
        return (T)this.convert(this.message);
    }

    private Object convert(io.vertx.amqp.AmqpMessage msg) {
        Section body = msg.unwrap().getBody();
        if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value instanceof Binary) {
                Binary bin = (Binary)value;
                byte[] bytes = new byte[bin.getLength()];
                System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
                return bytes;
            }
            return value;
        }
        if (body instanceof AmqpSequence) {
            List list = ((AmqpSequence)body).getValue();
            return list;
        }
        if (body instanceof Data) {
            Binary bin = ((Data)body).getValue();
            byte[] bytes = new byte[bin.getLength()];
            System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
            if ("application/json".equalsIgnoreCase(msg.contentType())) {
                return Buffer.buffer((byte[])bytes).toJson();
            }
            return bytes;
        }
        return body;
    }

    public org.apache.qpid.proton.message.Message unwrap() {
        return this.message.unwrap();
    }

    public boolean isDurable() {
        return this.message.isDurable();
    }

    public long getDeliveryCount() {
        return this.message.deliveryCount();
    }

    public int getPriority() {
        return this.message.priority();
    }

    public long getTtl() {
        return this.message.ttl();
    }

    public Object getMessageId() {
        return this.message.id();
    }

    public long getGroupSequence() {
        return this.message.groupSequence();
    }

    public long getCreationTime() {
        return this.message.creationTime();
    }

    public String getAddress() {
        return this.message.address();
    }

    public String getGroupId() {
        return this.message.groupId();
    }

    public String getContentType() {
        return this.message.contentType();
    }

    public long getExpiryTime() {
        return this.message.expiryTime();
    }

    public Object getCorrelationId() {
        return this.message.correlationId();
    }

    public String getContentEncoding() {
        return this.message.contentEncoding();
    }

    public String getSubject() {
        return this.message.subject();
    }

    public Header getHeader() {
        return this.message.unwrap().getHeader();
    }

    public JsonObject getApplicationProperties() {
        return this.message.applicationProperties();
    }

    public Section getBody() {
        return this.message.unwrap().getBody();
    }

    public MessageError getError() {
        return this.message.unwrap().getError();
    }

    public io.vertx.axle.amqp.AmqpMessage getAmqpMessage() {
        return new io.vertx.axle.amqp.AmqpMessage(this.message);
    }
}

