/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.reactive.messaging.amqp.AmqpMessageBuilder;
import io.smallrye.reactive.messaging.amqp.IncomingAmqpMetadata;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.buffer.Buffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.MessageError;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class AmqpMessage<T>
implements Message<T> {
    protected static final String APPLICATION_JSON = "application/json";
    protected final io.vertx.amqp.AmqpMessage message;
    protected final Metadata metadata;
    protected final IncomingAmqpMetadata amqpMetadata;

    public static <T> AmqpMessageBuilder<T> builder() {
        return new AmqpMessageBuilder();
    }

    public AmqpMessage(io.vertx.mutiny.amqp.AmqpMessage delegate) {
        this(delegate.getDelegate());
    }

    public AmqpMessage(io.vertx.amqp.AmqpMessage msg) {
        this.message = msg;
        IncomingAmqpMetadata.IncomingAmqpMetadataBuilder builder = new IncomingAmqpMetadata.IncomingAmqpMetadataBuilder();
        if (msg.address() != null) {
            builder.withAddress(msg.address());
        }
        if (msg.applicationProperties() != null) {
            builder.withProperties(msg.applicationProperties());
        }
        if (msg.contentType() != null) {
            builder.withContentType(msg.contentType());
        }
        if (msg.contentEncoding() != null) {
            builder.withContentEncoding(msg.contentEncoding());
        }
        if (msg.correlationId() != null) {
            builder.withCorrelationId(msg.correlationId());
        }
        if (msg.creationTime() > 0L) {
            builder.withCreationTime(msg.creationTime());
        }
        if (msg.deliveryCount() >= 0) {
            builder.withDeliveryCount(msg.deliveryCount());
        }
        if (msg.expiryTime() >= 0L) {
            builder.withExpirationTime(msg.expiryTime());
        }
        if (msg.groupId() != null) {
            builder.withGroupId(msg.groupId());
        }
        if (msg.groupSequence() >= 0L) {
            builder.withGroupSequence(msg.groupSequence());
        }
        if (msg.id() != null) {
            builder.withId(msg.id());
        }
        builder.withDurable(msg.isDurable());
        builder.withFirstAcquirer(msg.isFirstAcquirer());
        if (msg.priority() >= 0) {
            builder.withPriority(msg.priority());
        }
        if (msg.subject() != null) {
            builder.withSubject(msg.subject());
        }
        if (msg.ttl() >= 0L) {
            builder.withTtl(msg.ttl());
        }
        if (this.message.unwrap().getHeader() != null) {
            builder.withHeader(this.message.unwrap().getHeader());
        }
        this.amqpMetadata = builder.build();
        this.metadata = Metadata.of((Object[])new Object[]{builder.build()});
    }

    public CompletionStage<Void> ack() {
        this.message.accepted();
        return CompletableFuture.completedFuture(null);
    }

    public T getPayload() {
        return (T)this.convert(this.message);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private Object convert(io.vertx.amqp.AmqpMessage msg) {
        Section body = msg.unwrap().getBody();
        if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value instanceof Binary) {
                Binary bin = (Binary)value;
                byte[] bytes = new byte[bin.getLength()];
                System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
                return bytes;
            }
            return value;
        }
        if (body instanceof AmqpSequence) {
            return ((AmqpSequence)body).getValue();
        }
        if (body instanceof Data) {
            Binary bin = ((Data)body).getValue();
            byte[] bytes = new byte[bin.getLength()];
            System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
            if (APPLICATION_JSON.equalsIgnoreCase(msg.contentType())) {
                return Buffer.buffer((byte[])bytes).toJson();
            }
            return bytes;
        }
        return body;
    }

    public org.apache.qpid.proton.message.Message unwrap() {
        return this.message.unwrap();
    }

    public boolean isDurable() {
        return this.amqpMetadata.isDurable();
    }

    public long getDeliveryCount() {
        return this.amqpMetadata.getDeliveryCount();
    }

    public int getPriority() {
        return this.amqpMetadata.getPriority();
    }

    public long getTtl() {
        return this.amqpMetadata.getTtl();
    }

    public Object getMessageId() {
        return this.amqpMetadata.getId();
    }

    public long getGroupSequence() {
        return this.amqpMetadata.getGroupSequence();
    }

    public long getCreationTime() {
        return this.amqpMetadata.getCreationTime();
    }

    public String getAddress() {
        return this.amqpMetadata.getAddress();
    }

    public String getGroupId() {
        return this.amqpMetadata.getGroupId();
    }

    public String getContentType() {
        return this.amqpMetadata.getContentType();
    }

    public long getExpiryTime() {
        return this.amqpMetadata.getExpiryTime();
    }

    public Object getCorrelationId() {
        return this.amqpMetadata.getCorrelationId();
    }

    public String getContentEncoding() {
        return this.amqpMetadata.getContentEncoding();
    }

    public String getSubject() {
        return this.amqpMetadata.getSubject();
    }

    public Header getHeader() {
        return this.amqpMetadata.getHeader();
    }

    public JsonObject getApplicationProperties() {
        return this.amqpMetadata.getProperties();
    }

    public Section getBody() {
        return this.message.unwrap().getBody();
    }

    public MessageError getError() {
        return this.message.unwrap().getError();
    }

    public io.vertx.mutiny.amqp.AmqpMessage getAmqpMessage() {
        return new io.vertx.mutiny.amqp.AmqpMessage(this.message);
    }
}

