/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.fault;

import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPExceptions;
import io.vertx.mutiny.core.Context;
import java.util.concurrent.CompletionStage;

public interface AmqpFailureHandler {
    public <V> CompletionStage<Void> handle(AmqpMessage<V> var1, Context var2, Throwable var3);

    public static enum Strategy {
        FAIL,
        ACCEPT,
        RELEASE,
        REJECT;


        public static Strategy from(String s) {
            if (s == null || s.equalsIgnoreCase("fail")) {
                return FAIL;
            }
            if (s.equalsIgnoreCase("accept")) {
                return ACCEPT;
            }
            if (s.equalsIgnoreCase("release")) {
                return RELEASE;
            }
            if (s.equalsIgnoreCase("reject")) {
                return REJECT;
            }
            throw AMQPExceptions.ex.illegalArgumentUnknownFailureStrategy(s);
        }
    }
}

