/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class AmqpConnectorCommonConfiguration {
    protected final Config config;

    public AmqpConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public Optional<String> getUsername() {
        Optional maybe = this.config.getOptionalValue("username", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("amqp-username", String.class);
    }

    public Optional<String> getPassword() {
        Optional maybe = this.config.getOptionalValue("password", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("amqp-password", String.class);
    }

    public String getHost() {
        return this.config.getOptionalValue("host", String.class).orElseGet(() -> this.getFromAliasWithDefaultValue("amqp-host", String.class, "localhost"));
    }

    public Integer getPort() {
        return this.config.getOptionalValue("port", Integer.class).orElseGet(() -> this.getFromAliasWithDefaultValue("amqp-port", Integer.class, Integer.valueOf("5672")));
    }

    public Boolean getUseSsl() {
        return this.config.getOptionalValue("use-ssl", Boolean.class).orElseGet(() -> this.getFromAliasWithDefaultValue("amqp-use-ssl", Boolean.class, Boolean.valueOf("false")));
    }

    public Integer getReconnectAttempts() {
        return this.config.getOptionalValue("reconnect-attempts", Integer.class).orElseGet(() -> this.getFromAliasWithDefaultValue("amqp-reconnect-attempts", Integer.class, Integer.valueOf("100")));
    }

    public Integer getReconnectInterval() {
        return this.config.getOptionalValue("reconnect-interval", Integer.class).orElseGet(() -> this.getFromAliasWithDefaultValue("amqp-reconnect-interval", Integer.class, Integer.valueOf("10")));
    }

    public Integer getConnectTimeout() {
        return this.config.getOptionalValue("connect-timeout", Integer.class).orElseGet(() -> this.getFromAliasWithDefaultValue("amqp-connect-timeout", Integer.class, Integer.valueOf("1000")));
    }

    public Optional<String> getContainerId() {
        return this.config.getOptionalValue("container-id", String.class);
    }

    public Optional<String> getAddress() {
        return this.config.getOptionalValue("address", String.class);
    }

    public Optional<String> getLinkName() {
        return this.config.getOptionalValue("link-name", String.class);
    }

    public Optional<String> getClientOptionsName() {
        Optional maybe = this.config.getOptionalValue("client-options-name", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("amqp-client-options-name", String.class);
    }

    public void validate() {
    }
}

