/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.reactive.messaging.amqp.AmqpConnector;
import io.smallrye.reactive.messaging.amqp.AmqpConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPExceptions;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.mutiny.amqp.AmqpClient;
import io.vertx.mutiny.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.NamedLiteral;

public class AmqpClientHelper {
    private AmqpClientHelper() {
    }

    static AmqpClient createClient(AmqpConnector connector, AmqpConnectorCommonConfiguration config, Instance<AmqpClientOptions> instance) {
        Optional<String> clientOptionsName = config.getClientOptionsName();
        Vertx vertx = connector.getVertx();
        AmqpClient client = clientOptionsName.isPresent() ? AmqpClientHelper.createClientFromClientOptionsBean(vertx, instance, clientOptionsName.get()) : AmqpClientHelper.getClient(vertx, config);
        connector.addClient(client);
        return client;
    }

    static AmqpClient createClientFromClientOptionsBean(Vertx vertx, Instance<AmqpClientOptions> instance, String optionsBeanName) {
        Instance options = instance.select(new Annotation[]{NamedLiteral.of((String)optionsBeanName)});
        if (options.isUnsatisfied()) {
            throw AMQPExceptions.ex.illegalStateFindingBean(AmqpClientOptions.class.getName(), optionsBeanName);
        }
        AMQPLogging.log.createClientFromBean(optionsBeanName);
        return AmqpClient.create((Vertx)vertx, (AmqpClientOptions)((AmqpClientOptions)options.get()));
    }

    static AmqpClient getClient(Vertx vertx, AmqpConnectorCommonConfiguration config) {
        try {
            String username = config.getUsername().orElse(null);
            String password = config.getPassword().orElse(null);
            String host = config.getHost();
            int port = config.getPort();
            AMQPLogging.log.brokerConfigured(host, port, config.getChannel());
            boolean useSsl = config.getUseSsl();
            int reconnectAttempts = config.getReconnectAttempts();
            int reconnectInterval = config.getReconnectInterval();
            int connectTimeout = config.getConnectTimeout();
            String containerId = config.getContainerId().orElseGet(() -> config.config.getOptionalValue("containerId", String.class).orElse(null));
            AmqpClientOptions options = new AmqpClientOptions().setUsername(username).setPassword(password).setHost(host).setPort(port).setContainerId(containerId).setSsl(useSsl).setReconnectAttempts(reconnectAttempts).setReconnectInterval((long)reconnectInterval).setConnectTimeout(connectTimeout);
            config.getSniServerName().ifPresent(arg_0 -> ((AmqpClientOptions)options).setSniServerName(arg_0));
            config.getVirtualHost().ifPresent(arg_0 -> ((AmqpClientOptions)options).setVirtualHost(arg_0));
            return AmqpClient.create((Vertx)vertx, (AmqpClientOptions)options);
        }
        catch (Exception e) {
            AMQPLogging.log.unableToCreateClient(e);
            throw AMQPExceptions.ex.illegalStateUnableToCreateClient(e);
        }
    }
}

