/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.reactive.messaging.amqp.AmqpMessageBuilder;
import io.smallrye.reactive.messaging.amqp.IncomingAmqpMetadata;
import io.smallrye.reactive.messaging.amqp.fault.AmqpFailureHandler;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.Context;
import io.vertx.mutiny.core.buffer.Buffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.messaging.AmqpSequence;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Data;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.message.MessageError;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class AmqpMessage<T>
implements Message<T> {
    protected static final String APPLICATION_JSON = "application/json";
    protected final io.vertx.amqp.AmqpMessage message;
    protected final Metadata metadata;
    protected final IncomingAmqpMetadata amqpMetadata;
    private final Context context;
    protected final AmqpFailureHandler onNack;

    @Deprecated
    public static <T> AmqpMessageBuilder<T> builder() {
        return new AmqpMessageBuilder();
    }

    public AmqpMessage(io.vertx.mutiny.amqp.AmqpMessage delegate, Context context, AmqpFailureHandler onNack) {
        this(delegate.getDelegate(), context, onNack);
    }

    public AmqpMessage(io.vertx.amqp.AmqpMessage msg, Context context, AmqpFailureHandler onNack) {
        this.message = msg;
        this.context = context;
        this.amqpMetadata = new IncomingAmqpMetadata(this.message);
        this.metadata = Metadata.of((Object[])new Object[]{this.amqpMetadata});
        this.onNack = onNack;
    }

    public CompletionStage<Void> ack() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.context.runOnContext(() -> {
            this.message.accepted();
            future.complete(null);
        });
        return future;
    }

    public CompletionStage<Void> nack(Throwable reason) {
        return this.onNack.handle(this, this.context, reason);
    }

    public T getPayload() {
        return (T)this.convert(this.message);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    private Object convert(io.vertx.amqp.AmqpMessage msg) {
        Section body = msg.unwrap().getBody();
        if (body instanceof AmqpValue) {
            Object value = ((AmqpValue)body).getValue();
            if (value instanceof Binary) {
                Binary bin = (Binary)value;
                byte[] bytes = new byte[bin.getLength()];
                System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
                return bytes;
            }
            return value;
        }
        if (body instanceof AmqpSequence) {
            return ((AmqpSequence)body).getValue();
        }
        if (body instanceof Data) {
            Binary bin = ((Data)body).getValue();
            byte[] bytes = new byte[bin.getLength()];
            System.arraycopy(bin.getArray(), bin.getArrayOffset(), bytes, 0, bin.getLength());
            if (APPLICATION_JSON.equalsIgnoreCase(msg.contentType())) {
                return Buffer.buffer((byte[])bytes).toJson();
            }
            return bytes;
        }
        return body;
    }

    public org.apache.qpid.proton.message.Message unwrap() {
        return this.message.unwrap();
    }

    public boolean isDurable() {
        return this.amqpMetadata.isDurable();
    }

    public long getDeliveryCount() {
        return this.amqpMetadata.getDeliveryCount();
    }

    public int getPriority() {
        return this.amqpMetadata.getPriority();
    }

    public long getTtl() {
        return this.amqpMetadata.getTtl();
    }

    public Object getMessageId() {
        return this.amqpMetadata.getId();
    }

    public long getGroupSequence() {
        return this.amqpMetadata.getGroupSequence();
    }

    public long getCreationTime() {
        return this.amqpMetadata.getCreationTime();
    }

    public String getAddress() {
        return this.amqpMetadata.getAddress();
    }

    public String getGroupId() {
        return this.amqpMetadata.getGroupId();
    }

    public String getContentType() {
        return this.amqpMetadata.getContentType();
    }

    public long getExpiryTime() {
        return this.amqpMetadata.getExpiryTime();
    }

    public Object getCorrelationId() {
        return this.amqpMetadata.getCorrelationId();
    }

    public String getContentEncoding() {
        return this.amqpMetadata.getContentEncoding();
    }

    public String getSubject() {
        return this.amqpMetadata.getSubject();
    }

    public JsonObject getApplicationProperties() {
        return this.amqpMetadata.getProperties();
    }

    public Section getBody() {
        return this.message.unwrap().getBody();
    }

    public MessageError getError() {
        return this.message.unwrap().getError();
    }

    public io.vertx.mutiny.amqp.AmqpMessage getAmqpMessage() {
        return new io.vertx.mutiny.amqp.AmqpMessage(this.message);
    }

    public Supplier<CompletionStage<Void>> getAck() {
        return this::ack;
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return this::nack;
    }
}

