/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.fault;

import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.ConnectionHolder;
import io.smallrye.reactive.messaging.amqp.fault.AmqpFailureHandler;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.vertx.mutiny.core.Context;
import java.util.concurrent.CompletionStage;

public class AmqpAccept
implements AmqpFailureHandler {
    private final String channel;

    public AmqpAccept(String channel) {
        this.channel = channel;
    }

    @Override
    public <V> CompletionStage<Void> handle(AmqpMessage<V> msg, Context context, Throwable reason) {
        AMQPLogging.log.nackedAcceptMessage(this.channel);
        AMQPLogging.log.fullIgnoredFailure(reason);
        return ConnectionHolder.runOnContext(context, () -> msg.getAmqpMessage().accepted());
    }
}

