/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.common.annotation.Identifier;
import io.smallrye.reactive.messaging.amqp.AmqpConnector;
import io.smallrye.reactive.messaging.amqp.AmqpConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPExceptions;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.vertx.amqp.AmqpClientOptions;
import io.vertx.mutiny.amqp.AmqpClient;
import io.vertx.mutiny.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.literal.NamedLiteral;

public class AmqpClientHelper {
    private AmqpClientHelper() {
    }

    static AmqpClient createClient(AmqpConnector connector, AmqpConnectorCommonConfiguration config, Instance<AmqpClientOptions> instance) {
        Optional<String> clientOptionsName = config.getClientOptionsName();
        Vertx vertx = connector.getVertx();
        AmqpClient client = clientOptionsName.isPresent() ? AmqpClientHelper.createClientFromClientOptionsBean(vertx, instance, clientOptionsName.get(), config) : AmqpClientHelper.getClient(vertx, config);
        connector.addClient(client);
        return client;
    }

    static AmqpClient createClientFromClientOptionsBean(Vertx vertx, Instance<AmqpClientOptions> instance, String optionsBeanName, AmqpConnectorCommonConfiguration config) {
        Instance options = instance.select(new Annotation[]{Identifier.Literal.of((String)optionsBeanName)});
        if (options.isUnsatisfied() && !(options = instance.select(new Annotation[]{NamedLiteral.of((String)optionsBeanName)})).isUnsatisfied()) {
            ProviderLogging.log.deprecatedNamed();
        }
        if (options.isUnsatisfied()) {
            throw AMQPExceptions.ex.illegalStateFindingBean(AmqpClientOptions.class.getName(), optionsBeanName);
        }
        AMQPLogging.log.createClientFromBean(optionsBeanName);
        AmqpClientOptions clientOptions = AmqpClientHelper.getOptions(config);
        AmqpClientOptions completeOptions = (AmqpClientOptions)options.get();
        AmqpClientHelper.mergeTo(clientOptions, completeOptions);
        return AmqpClient.create((Vertx)vertx, (AmqpClientOptions)completeOptions);
    }

    static void mergeTo(AmqpClientOptions channel, AmqpClientOptions custom) {
        String username = channel.getUsername();
        String password = channel.getPassword();
        String host = channel.getHost();
        int port = channel.getPort();
        boolean useSsl = channel.isSsl();
        int reconnectAttempts = channel.getReconnectAttempts();
        long reconnectInterval = channel.getReconnectInterval();
        int connectTimeout = channel.getConnectTimeout();
        if (username != null) {
            custom.setUsername(channel.getUsername());
        }
        if (password != null) {
            custom.setPassword(channel.getPassword());
        }
        if (host != null) {
            custom.setHost(channel.getHost());
        }
        if (port > 0) {
            custom.setPort(channel.getPort());
        }
        if (useSsl) {
            custom.setSsl(channel.isSsl());
        }
        if (reconnectAttempts > 0) {
            custom.setReconnectAttempts(channel.getReconnectAttempts());
        }
        if (reconnectInterval > 0L) {
            custom.setReconnectInterval(channel.getReconnectInterval());
        }
        if (connectTimeout > 0) {
            custom.setConnectTimeout(channel.getConnectTimeout());
        }
    }

    static AmqpClientOptions getOptions(AmqpConnectorCommonConfiguration config) {
        String username = config.getUsername().orElse(null);
        String password = config.getPassword().orElse(null);
        String host = config.getHost();
        int port = config.getPort();
        AMQPLogging.log.brokerConfigured(host, port, config.getChannel());
        boolean useSsl = config.getUseSsl();
        int reconnectAttempts = config.getReconnectAttempts();
        int reconnectInterval = config.getReconnectInterval();
        int connectTimeout = config.getConnectTimeout();
        String containerId = config.getContainerId().orElseGet(() -> config.config.getOptionalValue("containerId", String.class).orElse(null));
        AmqpClientOptions options = new AmqpClientOptions().setUsername(username).setPassword(password).setHost(host).setPort(port).setContainerId(containerId).setSsl(useSsl).setReconnectAttempts(reconnectAttempts).setReconnectInterval((long)reconnectInterval).setConnectTimeout(connectTimeout);
        config.getSniServerName().ifPresent(arg_0 -> ((AmqpClientOptions)options).setSniServerName(arg_0));
        config.getVirtualHost().ifPresent(arg_0 -> ((AmqpClientOptions)options).setVirtualHost(arg_0));
        return options;
    }

    static AmqpClient getClient(Vertx vertx, AmqpConnectorCommonConfiguration config) {
        try {
            AmqpClientOptions options = AmqpClientHelper.getOptions(config);
            return AmqpClient.create((Vertx)vertx, (AmqpClientOptions)options);
        }
        catch (Exception e) {
            AMQPLogging.log.unableToCreateClient(e);
            throw AMQPExceptions.ex.illegalStateUnableToCreateClient(e);
        }
    }
}

