package io.smallrye.reactive.messaging.amqp.i18n;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class AMQPLogging_$logger extends DelegatingBasicLogger implements AMQPLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AMQPLogging_$logger.class.getName();
    public AMQPLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void createClientFromBean(final String optionsBeanName) {
        super.log.logf(FQCN, DEBUG, null, createClientFromBean$str(), optionsBeanName);
    }
    protected String createClientFromBean$str() {
        return "SRMSG16200: Creating AMQP client from bean named '%s'";
    }
    @Override
    public final void brokerConfigured(final String host, final int port, final String channel) {
        super.log.logf(FQCN, INFO, null, brokerConfigured$str(), host, port, channel);
    }
    protected String brokerConfigured$str() {
        return "SRMSG16201: AMQP broker configured to %s:%d for channel %s";
    }
    @Override
    public final void unableToCreateClient(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToCreateClient$str());
    }
    protected String unableToCreateClient$str() {
        return "SRMSG16202: Unable to create client";
    }
    @Override
    public final void receiverListeningAddress(final String address) {
        super.log.logf(FQCN, INFO, null, receiverListeningAddress$str(), address);
    }
    protected String receiverListeningAddress$str() {
        return "SRMSG16203: AMQP Receiver listening address %s";
    }
    @Override
    public final void receiverError(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, receiverError$str());
    }
    protected String receiverError$str() {
        return "SRMSG16204: AMQP Receiver error";
    }
    @Override
    public final void retrieveMessagesRetrying(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, retrieveMessagesRetrying$str());
    }
    protected String retrieveMessagesRetrying$str() {
        return "SRMSG16205: Unable to retrieve messages from AMQP, retrying...";
    }
    @Override
    public final void retrieveMessagesNoMoreRetrying(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, retrieveMessagesNoMoreRetrying$str());
    }
    protected String retrieveMessagesNoMoreRetrying$str() {
        return "SRMSG16206: Unable to retrieve messages from AMQP, no more retry";
    }
    @Override
    public final void messageNotSendClientClosed() {
        super.log.logf(FQCN, ERROR, null, messageNotSendClientClosed$str());
    }
    protected String messageNotSendClientClosed$str() {
        return "SRMSG16207: The AMQP message has not been sent, the client is closed";
    }
    @Override
    public final void unableToSendMessage(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToSendMessage$str());
    }
    protected String unableToSendMessage$str() {
        return "SRMSG16208: Unable to send the AMQP message";
    }
    @Override
    public final void unableToUseAddress(final String address, final String configuredAddress) {
        super.log.logf(FQCN, WARN, null, unableToUseAddress$str(), address, configuredAddress);
    }
    protected String unableToUseAddress$str() {
        return "SRMSG16209: Unable to use the address configured in the message (%s) - the connector is not using an anonymous sender, using %s instead";
    }
    @Override
    public final void messageToAddressNotSend(final String address) {
        super.log.logf(FQCN, ERROR, null, messageToAddressNotSend$str(), address);
    }
    protected String messageToAddressNotSend$str() {
        return "SRMSG16210: The AMQP message to address `%s` has not been sent, the client is closed";
    }
    @Override
    public final void sendingMessageToAddress(final String address) {
        super.log.logf(FQCN, DEBUG, null, sendingMessageToAddress$str(), address);
    }
    protected String sendingMessageToAddress$str() {
        return "SRMSG16211: Sending AMQP message to address `%s`";
    }
    @Override
    public final void establishingConnection() {
        super.log.logf(FQCN, INFO, null, establishingConnection$str());
    }
    protected String establishingConnection$str() {
        return "SRMSG16212: Establishing connection with AMQP broker";
    }
    @Override
    public final void connectionEstablished() {
        super.log.logf(FQCN, INFO, null, connectionEstablished$str());
    }
    protected String connectionEstablished$str() {
        return "SRMSG16213: Connection with AMQP broker established";
    }
    @Override
    public final void connectionFailure(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, connectionFailure$str());
    }
    protected String connectionFailure$str() {
        return "SRMSG16214: AMQP Connection failure";
    }
    @Override
    public final void unableToConnectToBroker(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToConnectToBroker$str());
    }
    protected String unableToConnectToBroker$str() {
        return "SRMSG16215: Unable to connect to the broker, retry will be attempted";
    }
    @Override
    public final void unableToRecoverFromConnectionDisruption(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToRecoverFromConnectionDisruption$str());
    }
    protected String unableToRecoverFromConnectionDisruption$str() {
        return "SRMSG16216: Unable to recover from AMQP connection disruption";
    }
    @Override
    public final void nackedAcceptMessage(final String channel) {
        super.log.logf(FQCN, WARN, null, nackedAcceptMessage$str(), channel);
    }
    protected String nackedAcceptMessage$str() {
        return "SRMSG16217: A message sent to channel `%s` has been nacked, ignoring the failure and marking the AMQP message as accepted";
    }
    @Override
    public final void fullIgnoredFailure(final Throwable t) {
        super.log.logf(FQCN, DEBUG, t, fullIgnoredFailure$str());
    }
    protected String fullIgnoredFailure$str() {
        return "SRMSG16218: The full ignored failure is";
    }
    @Override
    public final void nackedFailMessage(final String channel) {
        super.log.logf(FQCN, ERROR, null, nackedFailMessage$str(), channel);
    }
    protected String nackedFailMessage$str() {
        return "SRMSG16219: A message sent to channel `%s` has been nacked, rejecting the AMQP message and fail-stop";
    }
    @Override
    public final void nackedIgnoreMessage(final String channel) {
        super.log.logf(FQCN, WARN, null, nackedIgnoreMessage$str(), channel);
    }
    protected String nackedIgnoreMessage$str() {
        return "SRMSG16220: A message sent to channel `%s` has been nacked, ignoring the failure and marking the AMQP message as rejected";
    }
    @Override
    public final void nackedReleaseMessage(final String channel) {
        super.log.logf(FQCN, WARN, null, nackedReleaseMessage$str(), channel);
    }
    protected String nackedReleaseMessage$str() {
        return "SRMSG16221: A message sent to channel `%s` has been nacked, ignoring the failure and marking the AMQP message as released";
    }
    @Override
    public final void retrievedCreditsForChannel(final String channel, final long credits) {
        super.log.logf(FQCN, DEBUG, null, retrievedCreditsForChannel$str(), channel, credits);
    }
    protected String retrievedCreditsForChannel$str() {
        return "SRMSG16222: Retrieved credits for channel `%s`: %s";
    }
    @Override
    public final void noMoreCreditsForChannel(final String channel) {
        super.log.logf(FQCN, DEBUG, null, noMoreCreditsForChannel$str(), channel);
    }
    protected String noMoreCreditsForChannel$str() {
        return "SRMSG16223: No more credit for channel %s, requesting more credits";
    }
    @Override
    public final void messageNoSend(final String actualAddress) {
        super.log.logf(FQCN, ERROR, null, messageNoSend$str(), actualAddress);
    }
    protected String messageNoSend$str() {
        return "SRMSG16224: The AMQP message to address `%s` has not been sent, the client is closed";
    }
    @Override
    public final void failureReported(final String channel, final Throwable reason) {
        super.log.logf(FQCN, ERROR, reason, failureReported$str(), channel);
    }
    protected String failureReported$str() {
        return "SRMSG16225: Failure reported for channel `%s`, closing client";
    }
    @Override
    public final void nackedModifiedFailedMessage(final String channel) {
        super.log.logf(FQCN, WARN, null, nackedModifiedFailedMessage$str(), channel);
    }
    protected String nackedModifiedFailedMessage$str() {
        return "SRMSG16226: A message sent to channel `%s` has been nacked, ignoring the message and marking the AMQP message as modified with `delivery-failed`";
    }
    @Override
    public final void nackedModifiedFailedMessageAndUndeliverableHere(final String channel) {
        super.log.logf(FQCN, WARN, null, nackedModifiedFailedMessageAndUndeliverableHere$str(), channel);
    }
    protected String nackedModifiedFailedMessageAndUndeliverableHere$str() {
        return "SRMSG16227: A message sent to channel `%s` has been nacked, ignoring the message and marking the AMQP message as modified with `delivery-failed` and `undeliverable-here`";
    }
    @Override
    public final void serializationFailure(final String channel, final Throwable reason) {
        super.log.logf(FQCN, ERROR, reason, serializationFailure$str(), channel);
    }
    protected String serializationFailure$str() {
        return "SRMSG16228: Unable to serialize message on channel `%s`, message has been nacked";
    }
    @Override
    public final void unableToCreateMessage(final String channel, final Exception e) {
        super.log.logf(FQCN, ERROR, e, unableToCreateMessage$str(), channel);
    }
    protected String unableToCreateMessage$str() {
        return "SRMSG16229: Unable to deserialize AMQP message on channel `%s`, message ignored";
    }
}
