/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.vertx.amqp.AmqpMessage;
import io.vertx.core.json.JsonObject;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Footer;
import org.apache.qpid.proton.amqp.messaging.MessageAnnotations;

public class IncomingAmqpMetadata {
    private final AmqpMessage message;

    public IncomingAmqpMetadata(AmqpMessage message) {
        this.message = message;
    }

    public String getAddress() {
        return this.message.address();
    }

    public JsonObject getProperties() {
        return this.message.applicationProperties();
    }

    public String getContentType() {
        return this.message.unwrap().getContentType();
    }

    public String getContentEncoding() {
        return this.message.unwrap().getContentEncoding();
    }

    public long getCreationTime() {
        return this.message.creationTime();
    }

    public int getDeliveryCount() {
        return this.message.deliveryCount();
    }

    public long getExpiryTime() {
        return this.message.expiryTime();
    }

    public String getGroupId() {
        return this.message.groupId();
    }

    public long getGroupSequence() {
        return this.message.groupSequence();
    }

    public String getId() {
        return this.message.id();
    }

    public String getUserId() {
        byte[] userId = this.message.unwrap().getUserId();
        if (userId != null) {
            return new String(userId);
        }
        return null;
    }

    public boolean isDurable() {
        return this.message.isDurable();
    }

    public boolean isFirstAcquirer() {
        return this.message.isFirstAcquirer();
    }

    public short getPriority() {
        return (short)this.message.priority();
    }

    public String getSubject() {
        return this.message.subject();
    }

    public String getReplyTo() {
        return this.message.replyTo();
    }

    public String getReplyToGroupId() {
        return this.message.unwrap().getReplyToGroupId();
    }

    public String getCorrelationId() {
        return this.message.correlationId();
    }

    public long getTtl() {
        return this.message.ttl();
    }

    @Deprecated
    public long getExpirationTime() {
        return this.getExpiryTime();
    }

    public DeliveryAnnotations getDeliveryAnnotations() {
        return this.message.unwrap().getDeliveryAnnotations();
    }

    public MessageAnnotations getMessageAnnotations() {
        return this.message.unwrap().getMessageAnnotations();
    }

    public Footer getFooter() {
        return this.message.unwrap().getFooter();
    }
}

