package io.smallrye.reactive.messaging.amqp.i18n;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.Throwable;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class AMQPExceptions_$bundle implements AMQPExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected AMQPExceptions_$bundle() {}
    public static final AMQPExceptions_$bundle INSTANCE = new AMQPExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String illegalStateFindingBean$str() {
        return "SRMSG16000: Cannot find a %s bean named %s";
    }
    @Override
    public final IllegalStateException illegalStateFindingBean(final String className, final String beanName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateFindingBean$str(), className, beanName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalStateUnableToCreateClient$str() {
        return "SRMSG16001: Unable to create a client, probably a config error";
    }
    @Override
    public final IllegalStateException illegalStateUnableToCreateClient(final Throwable t) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnableToCreateClient$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidFailureStrategy$str() {
        return "SRMSG16002: Invalid failure strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidFailureStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidFailureStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateConnectionDisconnected$str() {
        return "SRMSG16003: AMQP Connection disconnected";
    }
    @Override
    public final IllegalStateException illegalStateConnectionDisconnected() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateConnectionDisconnected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentUnknownFailureStrategy$str() {
        return "SRMSG16004: Unknown failure strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentUnknownFailureStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentUnknownFailureStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateOnlyOneSubscriberAllowed$str() {
        return "SRMSG16005: Only one subscriber allowed";
    }
    @Override
    public final IllegalStateException illegalStateOnlyOneSubscriberAllowed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateOnlyOneSubscriberAllowed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
