/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.reactive.messaging.amqp.AmqpConnectorCommonConfiguration;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;

public class AmqpConnectorOutgoingConfiguration
extends AmqpConnectorCommonConfiguration {
    public AmqpConnectorOutgoingConfiguration(Config config) {
        super(config);
        this.validate();
    }

    public Boolean getDurable() {
        return this.config.getOptionalValue("durable", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Long getTtl() {
        return this.config.getOptionalValue("ttl", Long.class).orElse(Long.valueOf("0"));
    }

    public Integer getCreditRetrievalPeriod() {
        return this.config.getOptionalValue("credit-retrieval-period", Integer.class).orElse(Integer.valueOf("2000"));
    }

    public Long getMaxInflightMessages() {
        return this.config.getOptionalValue("max-inflight-messages", Long.class).orElse(Long.valueOf("0"));
    }

    public Optional<Boolean> getUseAnonymousSender() {
        return this.config.getOptionalValue("use-anonymous-sender", Boolean.class);
    }

    public Boolean getMerge() {
        return this.config.getOptionalValue("merge", Boolean.class).orElse(Boolean.valueOf("false"));
    }

    public Optional<String> getCloudEventsSource() {
        Optional maybe = this.config.getOptionalValue("cloud-events-source", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-source", String.class);
    }

    public Optional<String> getCloudEventsType() {
        Optional maybe = this.config.getOptionalValue("cloud-events-type", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-type", String.class);
    }

    public Optional<String> getCloudEventsSubject() {
        Optional maybe = this.config.getOptionalValue("cloud-events-subject", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-subject", String.class);
    }

    public Optional<String> getCloudEventsDataContentType() {
        Optional maybe = this.config.getOptionalValue("cloud-events-data-content-type", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-data-content-type", String.class);
    }

    public Optional<String> getCloudEventsDataSchema() {
        Optional maybe = this.config.getOptionalValue("cloud-events-data-schema", String.class);
        if (maybe.isPresent()) {
            return maybe;
        }
        return this.getFromAlias("cloud-events-default-data-schema", String.class);
    }

    public Boolean getCloudEventsInsertTimestamp() {
        return this.config.getOptionalValue("cloud-events-insert-timestamp", Boolean.class).orElseGet(() -> this.getFromAliasWithDefaultValue("cloud-events-default-timestamp", Boolean.class, Boolean.valueOf("true")));
    }

    public String getCloudEventsMode() {
        return this.config.getOptionalValue("cloud-events-mode", String.class).orElse("binary");
    }

    public Integer getRetryOnFailAttempts() {
        return this.config.getOptionalValue("retry-on-fail-attempts", Integer.class).orElse(Integer.valueOf("6"));
    }

    public Integer getRetryOnFailInterval() {
        return this.config.getOptionalValue("retry-on-fail-interval", Integer.class).orElse(Integer.valueOf("5"));
    }

    @Override
    public void validate() {
        super.validate();
    }
}

