/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessagingAttributesGetter;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;

public class AmqpAttributesExtractor
implements AttributesExtractor<AmqpMessage<?>, Void> {
    private final MessagingAttributesGetter<AmqpMessage<?>, Void> messagingAttributesGetter = new AmqpMessagingAttributesGetter();

    public MessagingAttributesGetter<AmqpMessage<?>, Void> getMessagingAttributesGetter() {
        return this.messagingAttributesGetter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, AmqpMessage<?> amqpMessage) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, AmqpMessage<?> amqpMessage, Void unused, Throwable error) {
    }

    private static class AmqpMessagingAttributesGetter
    implements MessagingAttributesGetter<AmqpMessage<?>, Void> {
        private AmqpMessagingAttributesGetter() {
        }

        public String system(AmqpMessage<?> amqpMessage) {
            return "AMQP 1.0";
        }

        public String destinationKind(AmqpMessage<?> amqpMessage) {
            return "queue";
        }

        public String destination(AmqpMessage<?> amqpMessage) {
            return amqpMessage.getAddress();
        }

        public boolean temporaryDestination(AmqpMessage<?> amqpMessage) {
            return false;
        }

        public String protocol(AmqpMessage<?> amqpMessage) {
            return "AMQP";
        }

        public String protocolVersion(AmqpMessage<?> amqpMessage) {
            return "1.0";
        }

        public String url(AmqpMessage<?> amqpMessage) {
            return null;
        }

        public String conversationId(AmqpMessage<?> amqpMessage) {
            Object correlationId = amqpMessage.getCorrelationId();
            return correlationId instanceof String ? (String)correlationId : null;
        }

        public Long messagePayloadSize(AmqpMessage<?> amqpMessage) {
            return null;
        }

        public Long messagePayloadCompressedSize(AmqpMessage<?> amqpMessage) {
            return null;
        }

        public String messageId(AmqpMessage<?> amqpMessage, Void unused) {
            Object messageId = amqpMessage.getMessageId();
            return messageId instanceof String ? (String)messageId : null;
        }
    }
}

