/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.amqp;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.amqp.AmqpConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.amqp.AmqpMessage;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPExceptions;
import io.smallrye.reactive.messaging.amqp.i18n.AMQPLogging;
import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.vertx.amqp.impl.AmqpConnectionImpl;
import io.vertx.core.Context;
import io.vertx.mutiny.amqp.AmqpClient;
import io.vertx.mutiny.amqp.AmqpConnection;
import io.vertx.mutiny.core.Vertx;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.qpid.proton.amqp.Symbol;

public class ConnectionHolder {
    private final AmqpClient client;
    private final AmqpConnectorCommonConfiguration configuration;
    private final AtomicReference<CurrentConnection> holder = new AtomicReference();
    private final Vertx vertx;
    private final io.vertx.mutiny.core.Context root;
    private Consumer<Throwable> onFailure;

    public ConnectionHolder(AmqpClient client, AmqpConnectorCommonConfiguration configuration, Vertx vertx, io.vertx.mutiny.core.Context root) {
        this.client = client;
        this.configuration = configuration;
        this.vertx = vertx;
        this.root = root;
    }

    public io.vertx.mutiny.core.Context getContext() {
        CurrentConnection connection = this.holder.get();
        if (connection != null) {
            return connection.context;
        }
        return null;
    }

    @CheckReturnValue
    public Uni<Boolean> isConnected() {
        CurrentConnection connection = this.holder.get();
        if (connection == null) {
            return Uni.createFrom().item((Object)false);
        }
        AmqpConnection underlying = connection.connection;
        if (underlying == null) {
            return Uni.createFrom().item((Object)false);
        }
        return Uni.createFrom().item(() -> !underlying.isDisconnected()).runSubscriptionOn(arg_0 -> ((io.vertx.mutiny.core.Context)connection.context).runOnContext(arg_0));
    }

    public static List<String> capabilities(AmqpConnection connection) {
        Symbol[] capabilities = ((AmqpConnectionImpl)connection.getDelegate()).unwrap().getRemoteOfferedCapabilities();
        return Arrays.stream(capabilities).map(Symbol::toString).collect(Collectors.toList());
    }

    public static boolean supportAnonymousRelay(AmqpConnection connection) {
        return ConnectionHolder.capabilities(connection).contains("ANONYMOUS-RELAY");
    }

    public Vertx getVertx() {
        return this.vertx;
    }

    public int getHealthTimeout() {
        return this.configuration.getHealthTimeout();
    }

    public synchronized void onFailure(Consumer<Throwable> callback) {
        this.onFailure = callback;
    }

    @CheckReturnValue
    public Uni<AmqpConnection> getOrEstablishConnection() {
        return Uni.createFrom().item(() -> {
            CurrentConnection connection = this.holder.get();
            if (connection != null && connection.connection != null && !connection.connection.isDisconnected()) {
                return connection.connection;
            }
            return null;
        }).onItem().ifNull().switchTo(() -> {
            Integer retryInterval = this.configuration.getReconnectInterval();
            Integer retryAttempts = this.configuration.getReconnectAttempts();
            CurrentConnection reference = this.holder.get();
            if (reference != null && reference.connection != null && !reference.connection.isDisconnected()) {
                AmqpConnection connection = reference.connection;
                return Uni.createFrom().item((Object)connection);
            }
            return this.client.connect().onSubscription().invoke(s -> AMQPLogging.log.establishingConnection()).onItem().transform(conn -> {
                AMQPLogging.log.connectionEstablished();
                this.holder.set(new CurrentConnection((AmqpConnection)conn, this.root == null ? Vertx.currentContext() : this.root));
                conn.exceptionHandler(t -> {
                    Consumer<Throwable> c;
                    this.holder.set(null);
                    AMQPLogging.log.connectionFailure((Throwable)t);
                    ConnectionHolder connectionHolder = this;
                    synchronized (connectionHolder) {
                        c = this.onFailure;
                    }
                    if (c != null) {
                        c.accept((Throwable)t);
                    }
                });
                if (conn.isDisconnected() || this.holder.get() == null) {
                    this.holder.set(null);
                    throw AMQPExceptions.ex.illegalStateConnectionDisconnected();
                }
                return conn;
            }).onFailure().invoke(AMQPLogging.log::unableToConnectToBroker).onFailure().retry().withBackOff(Duration.ofSeconds(1L), Duration.ofSeconds(retryInterval.intValue())).atMost((long)retryAttempts.intValue()).onFailure().invoke(t -> {
                this.holder.set(null);
                AMQPLogging.log.unableToRecoverFromConnectionDisruption((Throwable)t);
            });
        });
    }

    public static CompletionStage<Void> runOnContext(io.vertx.mutiny.core.Context context, AmqpMessage<?> msg, Consumer<io.vertx.mutiny.amqp.AmqpMessage> handle) {
        return VertxContext.runOnContext((Context)context.getDelegate(), f -> {
            handle.accept(msg.getAmqpMessage());
            msg.runOnMessageContext(() -> f.complete(null));
        });
    }

    public static CompletionStage<Void> runOnContextAndReportFailure(io.vertx.mutiny.core.Context context, AmqpMessage<?> msg, Throwable reason, Consumer<io.vertx.mutiny.amqp.AmqpMessage> handle) {
        return VertxContext.runOnContext((Context)context.getDelegate(), f -> {
            handle.accept(msg.getAmqpMessage());
            msg.runOnMessageContext(() -> f.completeExceptionally(reason));
        });
    }

    private static class CurrentConnection {
        final AmqpConnection connection;
        final io.vertx.mutiny.core.Context context;

        private CurrentConnection(AmqpConnection connection, io.vertx.mutiny.core.Context context) {
            this.connection = connection;
            this.context = context;
        }
    }
}

