|Attribute (_alias_) | Description | Type   | Mandatory | Default |
| :---               | :----       | :----: | :----:    | :---    |
| *address* | The AMQP address. If not set, the channel name is used | string | false |  |
| *capabilities* | A comma-separated list of capabilities proposed by the sender or receiver client. | string | false |  |
| *client-options-name* _(amqp-client-options-name)_ | The name of the AMQP Client Option bean used to customize the AMQP client configuration | string | false |  |
| *cloud-events* | Enables (default) or disables the Cloud Event support. If enabled on an _incoming_ channel, the connector analyzes the incoming records and try to create Cloud Event metadata. If enabled on an _outgoing_, the connector sends the outgoing messages as Cloud Event if the message includes Cloud Event Metadata. | boolean | false | `true` |
| *cloud-events-data-content-type* _(cloud-events-default-data-content-type)_ | Configure the default `datacontenttype` attribute of the outgoing Cloud Event. Requires `cloud-events` to be set to `true`. This value is used if the message does not configure the `datacontenttype` attribute itself | string | false |  |
| *cloud-events-data-schema* _(cloud-events-default-data-schema)_ | Configure the default `dataschema` attribute of the outgoing Cloud Event. Requires `cloud-events` to be set to `true`. This value is used if the message does not configure the `dataschema` attribute itself | string | false |  |
| *cloud-events-insert-timestamp* _(cloud-events-default-timestamp)_ | Whether or not the connector should insert automatically the `time` attribute into the outgoing Cloud Event. Requires `cloud-events` to be set to `true`. This value is used if the message does not configure the `time` attribute itself | boolean | false | `true` |
| *cloud-events-mode* | The Cloud Event mode (`structured` or `binary` (default)). Indicates how are written the cloud events in the outgoing record | string | false | `binary` |
| *cloud-events-source* _(cloud-events-default-source)_ | Configure the default `source` attribute of the outgoing Cloud Event. Requires `cloud-events` to be set to `true`. This value is used if the message does not configure the `source` attribute itself | string | false |  |
| *cloud-events-subject* _(cloud-events-default-subject)_ | Configure the default `subject` attribute of the outgoing Cloud Event. Requires `cloud-events` to be set to `true`. This value is used if the message does not configure the `subject` attribute itself | string | false |  |
| *cloud-events-type* _(cloud-events-default-type)_ | Configure the default `type` attribute of the outgoing Cloud Event. Requires `cloud-events` to be set to `true`. This value is used if the message does not configure the `type` attribute itself | string | false |  |
| *connect-timeout* _(amqp-connect-timeout)_ | The connection timeout in milliseconds | int | false | `1000` |
| *container-id* | The AMQP container id | string | false |  |
| *credit-retrieval-period* | The period (in milliseconds) between two attempts to retrieve the credits granted by the broker. This time is used when the sender run out of credits. | int | false | `2000` |
| *durable* | Whether sent AMQP messages are marked durable | boolean | false | `false` |
| *health-timeout* | The max number of seconds to wait to determine if the connection with the broker is still established for the readiness check. After that threshold, the check is considered as failed. | int | false | `3` |
| *host* _(amqp-host)_ | The broker hostname | string | false | `localhost` |
| *lazy-client* | Whether to create the connection and sender at startup or at first send request | boolean | false | `true` |
| *link-name* | The name of the link. If not set, the channel name is used. | string | false |  |
| *max-inflight-messages* | The maximum number of messages to be written to the broker concurrently. The number of sent messages waiting to be acknowledged by the broker are limited by this value and credits granted by the broker. The default value `0` means only credits apply. | long | false | `0` |
| *merge* | Whether the connector should allow multiple upstreams | boolean | false | `false` |
| *password* _(amqp-password)_ | The password used to authenticate to the broker | string | false |  |
| *port* _(amqp-port)_ | The broker port | int | false | `5672` |
| *reconnect-attempts* _(amqp-reconnect-attempts)_ | The number of reconnection attempts | int | false | `100` |
| *reconnect-interval* _(amqp-reconnect-interval)_ | The interval in second between two reconnection attempts | int | false | `10` |
| *retry-on-fail-attempts* | The number of tentative to retry on failure | int | false | `6` |
| *retry-on-fail-interval* | The interval (in seconds) between two sending attempts | int | false | `5` |
| *sni-server-name* _(amqp-sni-server-name)_ | If set, explicitly override the hostname to use for the TLS SNI server name | string | false |  |
| *tracing-enabled* | Whether tracing is enabled (default) or disabled | boolean | false | `true` |
| *ttl* | The time-to-live of the send AMQP messages. 0 to disable the TTL | long | false | `0` |
| *use-anonymous-sender* | Whether or not the connector should use an anonymous sender. Default value is `true` if the broker supports it, `false` otherwise. If not supported, it is not possible to dynamically change the destination address. | boolean | false |  |
| *use-ssl* _(amqp-use-ssl)_ | Whether the AMQP connection uses SSL/TLS | boolean | false | `false` |
| *username* _(amqp-username)_ | The username used to authenticate to the broker | string | false |  |
| *virtual-host* _(amqp-virtual-host)_ | If set, configure the hostname value used for the connection AMQP Open frame and TLS SNI server name (if TLS is in use) | string | false |  |
