/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public interface Message<T> {
    public static <T> Message<T> of(T payload) {
        return () -> payload;
    }

    public static <T> Message<T> of(final T payload, Metadata metadata) {
        if (payload == null) {
            throw new IllegalArgumentException("`payload` must not be `null`");
        }
        if (metadata == null) {
            metadata = Metadata.empty();
        }
        final Metadata actual = metadata;
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return actual;
            }
        };
    }

    public static <T> Message<T> of(final T payload, Iterable<Object> metadata) {
        if (payload == null) {
            throw new IllegalArgumentException("`payload` must not be `null`");
        }
        final Metadata validated = Metadata.from(metadata);
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return validated;
            }
        };
    }

    public static <T> Message<T> of(final T payload, final Supplier<CompletionStage<Void>> ack) {
        if (payload == null) {
            throw new IllegalArgumentException("`payload` must not be `null`");
        }
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return Metadata.empty();
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }
        };
    }

    public static <T> Message<T> of(final T payload, Metadata metadata, final Supplier<CompletionStage<Void>> ack) {
        if (payload == null) {
            throw new IllegalArgumentException("`payload` must not be `null`");
        }
        if (metadata == null) {
            metadata = Metadata.empty();
        }
        final Metadata actual = metadata;
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return actual;
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }
        };
    }

    public static <T> Message<T> of(final T payload, Iterable<Object> metadata, final Supplier<CompletionStage<Void>> ack) {
        final Metadata validated = Metadata.from(metadata);
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return validated;
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }
        };
    }

    default public <P> Message<P> withPayload(P payload) {
        return Message.of(payload, Metadata.from(this.getMetadata()), this.getAck());
    }

    default public Message<T> withMetadata(Iterable<Object> metadata) {
        return Message.of(this.getPayload(), Metadata.from(metadata), this.getAck());
    }

    default public Message<T> withMetadata(Metadata metadata) {
        return Message.of(this.getPayload(), Metadata.from(metadata), this.getAck());
    }

    default public Message<T> withAck(Supplier<CompletionStage<Void>> supplier) {
        return Message.of(this.getPayload(), this.getMetadata(), supplier);
    }

    public T getPayload();

    default public Metadata getMetadata() {
        return Metadata.empty();
    }

    default public <M> Optional<M> getMetadata(Class<? extends M> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("`clazz` must not be `null`");
        }
        return StreamSupport.stream(this.getMetadata().spliterator(), false).filter(clazz::isInstance).map(x -> x).findAny();
    }

    default public Supplier<CompletionStage<Void>> getAck() {
        return () -> CompletableFuture.completedFuture(null);
    }

    default public CompletionStage<Void> ack() {
        Supplier<CompletionStage<Void>> ack = this.getAck();
        if (ack == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ack.get();
    }

    default public <C> C unwrap(Class<C> unwrapType) {
        if (unwrapType == null) {
            throw new IllegalArgumentException("The target class must not be `null`");
        }
        try {
            return unwrapType.cast(this);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot unwrap an instance of " + this.getClass().getName() + " to " + unwrapType.getName(), e);
        }
    }

    default public Message<T> addMetadata(Object metadata) {
        return Message.of(this.getPayload(), this.getMetadata().with(metadata), this.getAck());
    }
}

