/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;

public class Metadata
implements Iterable<Object> {
    private final Set<Object> backend;
    private static final Metadata EMPTY = new Metadata(Collections.emptySet());

    private Metadata(Set<Object> backend) {
        this.backend = Collections.unmodifiableSet(backend);
    }

    public static Metadata empty() {
        return EMPTY;
    }

    static Metadata of(Object metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        return new Metadata(Collections.singleton(metadata));
    }

    public static Metadata of(Object ... metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        Set<Object> set = Metadata.addMetadataToSet(Arrays.asList(metadata));
        return new Metadata(set);
    }

    public static Metadata from(Iterable<Object> iterable) {
        if (iterable == null) {
            throw new IllegalArgumentException("`iterable` must not be `null`");
        }
        if (iterable instanceof Metadata) {
            return (Metadata)iterable;
        }
        Set<Object> set = Metadata.addMetadataToSet(iterable);
        if (set.isEmpty()) {
            return Metadata.empty();
        }
        return new Metadata(set);
    }

    private static Set<Object> addMetadataToSet(Iterable<Object> iterable) {
        LinkedHashSet<Object> set = new LinkedHashSet<Object>();
        for (Object meta : iterable) {
            if (meta == null) {
                throw new IllegalArgumentException("One of the item is `null`");
            }
            Optional<Object> contained = Metadata.contains(set, meta);
            if (contained.isPresent()) {
                throw new IllegalArgumentException("Duplicated metadata detected: " + meta.getClass().getName());
            }
            set.add(meta);
        }
        return set;
    }

    private static Optional<Object> contains(Set<Object> set, Object meta) {
        return set.stream().filter(o -> o.getClass().equals(meta.getClass())).findAny();
    }

    public Metadata with(Object meta) {
        if (meta == null) {
            throw new IllegalArgumentException("`meta` must not be `null`");
        }
        LinkedHashSet<Object> copy = new LinkedHashSet<Object>(this.backend);
        Metadata.contains(this.backend, meta).ifPresent(copy::remove);
        copy.add(meta);
        return new Metadata(copy);
    }

    public Metadata without(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("`clazz` must not be `null`");
        }
        LinkedHashSet<Object> copy = new LinkedHashSet<Object>(this.backend);
        copy.stream().filter(o -> o.getClass().equals(clazz)).findAny().ifPresent(copy::remove);
        return new Metadata(copy);
    }

    public Metadata copy() {
        LinkedHashSet<Object> copy = new LinkedHashSet<Object>(this.backend);
        return new Metadata(copy);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.backend.iterator();
    }
}

