/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging;

import io.smallrye.common.annotation.Experimental;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

@Experimental(value="metadata propagation is a SmallRye-specific feature")
public class Metadata
implements Iterable<Object> {
    private final Map<Class<?>, Object> backend;
    private static final Metadata EMPTY = new Metadata(Collections.emptyMap());

    private Metadata(Map<Class<?>, Object> backend) {
        this.backend = Collections.unmodifiableMap(backend);
    }

    public static Metadata empty() {
        return EMPTY;
    }

    static Metadata of(Object metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        return new Metadata(Collections.singletonMap(metadata.getClass(), metadata));
    }

    public static Metadata of(Object ... metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        Map<Class<?>, Object> map = Metadata.createBackingMap(Arrays.asList(metadata));
        return new Metadata(map);
    }

    public static Metadata from(Iterable<Object> metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("`metadata` must not be `null`");
        }
        if (metadata instanceof Metadata) {
            return (Metadata)metadata;
        }
        Map<Class<?>, Object> map = Metadata.createBackingMap(metadata);
        if (map.isEmpty()) {
            return Metadata.empty();
        }
        return new Metadata(map);
    }

    private static Map<Class<?>, Object> createBackingMap(Iterable<Object> metadata) {
        HashMap map = new HashMap();
        for (Object item : metadata) {
            if (item == null) {
                throw new IllegalArgumentException("One of the metadata items is `null`");
            }
            if (map.containsKey(item.getClass())) {
                throw new IllegalArgumentException("Duplicate metadata detected: " + item.getClass().getName());
            }
            map.put(item.getClass(), item);
        }
        return map;
    }

    public Metadata with(Object item) {
        if (item == null) {
            throw new IllegalArgumentException("`item` must not be `null`");
        }
        HashMap copy = new HashMap(this.backend);
        copy.put(item.getClass(), item);
        return new Metadata(copy);
    }

    public Metadata without(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("`clazz` must not be `null`");
        }
        HashMap copy = new HashMap(this.backend);
        copy.remove(clazz);
        return new Metadata(copy);
    }

    public Metadata copy() {
        HashMap copy = new HashMap(this.backend);
        return new Metadata(copy);
    }

    public <T> Optional<T> get(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("`clazz` must not be `null`");
        }
        return Optional.ofNullable(clazz.cast(this.backend.get(clazz)));
    }

    @Override
    public Iterator<Object> iterator() {
        return this.backend.values().iterator();
    }
}

