/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.aws.sqs;

import io.smallrye.reactive.messaging.aws.sqs.SqsConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.aws.sqs.i18n.AwsSqsLogging;
import java.lang.reflect.Method;
import java.util.Objects;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;

public class SqsClientConfig {
    private final String queueName;
    private final String queueUrl;
    private final Region region;
    private final String endpointOverride;
    private final String credentialsProviderClassName;

    public SqsClientConfig(SqsConnectorCommonConfiguration config) {
        this.queueName = config.getQueue().orElse(config.getChannel());
        this.queueUrl = config.getQueueUrl().orElse(null);
        this.region = config.getRegion().map(Region::of).orElse(null);
        this.endpointOverride = config.getEndpointOverride().orElse(null);
        this.credentialsProviderClassName = config.getCredentialsProvider().orElse(null);
    }

    public boolean isComplete() {
        return this.queueName != null && this.region != null;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public String getEndpointOverride() {
        return this.endpointOverride;
    }

    public Region getRegion() {
        return this.region;
    }

    public String getCredentialsProviderClassName() {
        return this.credentialsProviderClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqsClientConfig that = (SqsClientConfig)o;
        return Objects.equals(this.endpointOverride, that.endpointOverride) && Objects.equals(this.region, that.region) && Objects.equals(this.queueName, that.queueName) && Objects.equals(this.queueUrl, that.queueUrl) && Objects.equals(this.credentialsProviderClassName, that.credentialsProviderClassName);
    }

    public int hashCode() {
        return Objects.hash(this.endpointOverride, this.region, this.queueName, this.queueUrl, this.credentialsProviderClassName);
    }

    public AwsCredentialsProvider createCredentialsProvider() {
        String className = this.credentialsProviderClassName == null ? "software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider" : this.credentialsProviderClassName;
        try {
            Class<?> clazz = Class.forName(className);
            Method method = clazz.getMethod("create", new Class[0]);
            return (AwsCredentialsProvider)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            AwsSqsLogging.log.failedToLoadAwsCredentialsProvider(e.getMessage());
            return DefaultCredentialsProvider.create();
        }
    }
}

