/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.aws.sqs;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class SqsConnectorCommonConfiguration {
    protected final Config config;

    public SqsConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public Optional<String> getQueue() {
        return this.config.getOptionalValue("queue", String.class);
    }

    public Optional<String> getQueueUrl() {
        return this.config.getOptionalValue("queue.url", String.class);
    }

    public Optional<String> getRegion() {
        return this.config.getOptionalValue("region", String.class);
    }

    public Optional<String> getEndpointOverride() {
        return this.config.getOptionalValue("endpoint-override", String.class);
    }

    public Optional<String> getCredentialsProvider() {
        return this.config.getOptionalValue("credentials-provider", String.class);
    }

    public Boolean getHealthEnabled() {
        return this.config.getOptionalValue("health-enabled", Boolean.class).orElse(Boolean.valueOf("true"));
    }

    public void validate() {
    }
}

