/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.aws.sqs;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.aws.sqs.SqsClientConfig;
import io.smallrye.reactive.messaging.aws.sqs.SqsConnectorCommonConfiguration;
import io.smallrye.reactive.messaging.aws.sqs.i18n.AwsSqsExceptions;
import io.smallrye.reactive.messaging.aws.sqs.i18n.AwsSqsLogging;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.inject.Inject;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.SqsAsyncClientBuilder;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@ApplicationScoped
public class SqsManager {
    @Inject
    Instance<SqsAsyncClient> clientInstance;
    private final Map<SqsClientConfig, SqsAsyncClient> clients = new ConcurrentHashMap<SqsClientConfig, SqsAsyncClient>();
    private final Map<SqsClientConfig, String> queueUrls = new ConcurrentHashMap<SqsClientConfig, String>();

    public void terminate(@Observes(notifyObserver=Reception.IF_EXISTS) @Priority(value=50) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        this.clients.entrySet().stream().filter(e -> ((SqsClientConfig)e.getKey()).isComplete() && e.getValue() != null).map(Map.Entry::getValue).forEach(SdkAutoCloseable::close);
    }

    private SqsAsyncClient getClient(SqsClientConfig config) {
        return this.clients.computeIfAbsent(config, c -> {
            if (this.clientInstance.isResolvable() && !c.isComplete()) {
                return (SqsAsyncClient)this.clientInstance.get();
            }
            try {
                SqsAsyncClientBuilder builder = SqsAsyncClient.builder();
                if (c.getEndpointOverride() != null) {
                    builder.endpointOverride(URI.create(c.getEndpointOverride()));
                }
                if (c.getRegion() != null) {
                    builder.region(c.getRegion());
                }
                builder.credentialsProvider(config.createCredentialsProvider());
                return (SqsAsyncClient)builder.build();
            }
            catch (Exception e) {
                throw new DeploymentException("The required configuration property \"region\" is missing", (Throwable)e);
            }
        });
    }

    public SqsAsyncClient getClient(SqsConnectorCommonConfiguration config) {
        return this.getClient(new SqsClientConfig(config));
    }

    public Uni<String> getQueueUrl(SqsConnectorCommonConfiguration config) {
        SqsClientConfig clientConfig = new SqsClientConfig(config);
        if (clientConfig.getQueueUrl() != null || this.queueUrls.containsKey(clientConfig)) {
            return Uni.createFrom().item((Object)this.queueUrls.computeIfAbsent(clientConfig, c -> {
                AwsSqsLogging.log.queueUrlForChannel(config.getChannel(), clientConfig.getQueueUrl());
                return clientConfig.getQueueUrl();
            }));
        }
        return Uni.createFrom().completionStage(() -> this.getClient(clientConfig).getQueueUrl(r -> r.queueName(clientConfig.getQueueName()).build())).map(GetQueueUrlResponse::queueUrl).invoke(queueUrl -> this.queueUrls.put(clientConfig, (String)queueUrl)).invoke(queueUrl -> AwsSqsLogging.log.queueUrlForChannel(config.getChannel(), (String)queueUrl)).onFailure().transform(AwsSqsExceptions.ex::illegalStateUnableToRetrieveQueueUrl);
    }
}

