/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.aws.sqs.ack;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.aws.sqs.SqsAckHandler;
import io.smallrye.reactive.messaging.aws.sqs.SqsMessage;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.DeleteMessageRequest;

public class SqsDeleteAckHandler
implements SqsAckHandler {
    private final SqsAsyncClient client;
    private final Uni<String> queueUrlUni;

    public SqsDeleteAckHandler(SqsAsyncClient client, Uni<String> queueUrlUni) {
        this.client = client;
        this.queueUrlUni = queueUrlUni;
    }

    @Override
    public Uni<Void> handle(SqsMessage message) {
        return this.queueUrlUni.map(queueUrl -> (DeleteMessageRequest)DeleteMessageRequest.builder().queueUrl(queueUrl).receiptHandle(message.getMessage().receiptHandle()).build()).chain(request -> Uni.createFrom().completionStage(() -> this.client.deleteMessage(request))).replaceWithVoid().emitOn(arg_0 -> ((SqsMessage)message).runOnMessageContext(arg_0));
    }
}

