package io.smallrye.reactive.messaging.aws.sqs;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;

/**
 * Extract the outgoing configuration for the {@code smallrye-sqs} connector.
*/
public class SqsConnectorOutgoingConfiguration extends SqsConnectorCommonConfiguration {

  /**
   * Creates a new SqsConnectorOutgoingConfiguration.
   */
  public SqsConnectorOutgoingConfiguration(Config config) {
    super(config);
    validate();
  }

  /**
  * Gets the group.id value from the configuration.
  * Attribute Name: group.id
  * Description: When set, sends messages with the specified group id
  * @return the group.id
  */
  public Optional<String> getGroupId() {
    return config.getOptionalValue("group.id", String.class);
  }

  public void validate() {
    super.validate();
  }
}
