package io.smallrye.reactive.messaging.aws.sqs.i18n;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.Throwable;
import java.lang.String;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class AwsSqsExceptions_$bundle implements AwsSqsExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected AwsSqsExceptions_$bundle() {}
    public static final AwsSqsExceptions_$bundle INSTANCE = new AwsSqsExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String illegalStateUnableToRetrieveQueueUrl$str() {
        return "SRMSG19400: Failed to retrieve AWS Sqs queue url";
    }
    @Override
    public final IllegalStateException illegalStateUnableToRetrieveQueueUrl(final Throwable t) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnableToRetrieveQueueUrl$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalStateUnableToLoadClass$str() {
        return "SRMSG19401: Unable to load the class %s";
    }
    @Override
    public final IllegalStateException illegalStateUnableToLoadClass(final String className, final Throwable t) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnableToLoadClass$str(), className), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
