package io.smallrye.reactive.messaging.aws.sqs.i18n;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.TRACE;
import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class AwsSqsLogging_$logger extends DelegatingBasicLogger implements AwsSqsLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = AwsSqsLogging_$logger.class.getName();
    public AwsSqsLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void receivedMessage(final String message) {
        super.log.logf(FQCN, TRACE, null, receivedMessage$str(), message);
    }
    protected String receivedMessage$str() {
        return "SRMSG19300: Received Aws Sqs message %s";
    }
    @Override
    public final void receivedEmptyMessage() {
        super.log.logf(FQCN, TRACE, null, receivedEmptyMessage$str());
    }
    protected String receivedEmptyMessage$str() {
        return "SRMSG19301: Aws Sqs message is null";
    }
    @Override
    public final void errorReceivingMessage(final String channel, final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorReceivingMessage$str(), channel);
    }
    protected String errorReceivingMessage$str() {
        return "SRMSG19302: Error while receiving the message from channel '%s'";
    }
    @Override
    public final void failedToLoadAwsCredentialsProvider(final String message) {
        super.log.logf(FQCN, WARN, null, failedToLoadAwsCredentialsProvider$str(), message);
    }
    protected String failedToLoadAwsCredentialsProvider$str() {
        return "SRMSG19303: Failed to load the AWS credentials provider, using the default credential provider chain %s";
    }
    @Override
    public final void queueUrlForChannel(final String channel, final String queueUrl) {
        super.log.logf(FQCN, INFO, null, queueUrlForChannel$str(), channel, queueUrl);
    }
    protected String queueUrlForChannel$str() {
        return "SRMSG19304: Queue URL for channel %s : %s";
    }
    @Override
    public final void messageSentToChannel(final String channel, final String messageId, final String sequence) {
        super.log.logf(FQCN, DEBUG, null, messageSentToChannel$str(), channel, messageId, sequence);
    }
    protected String messageSentToChannel$str() {
        return "SRMSG19305: Message sent for channel %s with message id %s and sequence number %s";
    }
    @Override
    public final void unableToDispatch(final String channel, final Throwable e) {
        super.log.logf(FQCN, ERROR, e, unableToDispatch$str(), channel);
    }
    protected String unableToDispatch$str() {
        return "SRMSG19306: Error while sending message from channel '%s'";
    }
}
