/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.aws.sqs;

import io.smallrye.reactive.messaging.aws.sqs.SqsAckHandler;
import io.smallrye.reactive.messaging.aws.sqs.SqsIncomingMetadata;
import io.smallrye.reactive.messaging.aws.sqs.i18n.AwsSqsExceptions;
import io.smallrye.reactive.messaging.json.JsonMapping;
import io.smallrye.reactive.messaging.providers.MetadataInjectableMessage;
import io.smallrye.reactive.messaging.providers.locals.ContextAwareMessage;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import software.amazon.awssdk.services.sqs.model.Message;
import software.amazon.awssdk.services.sqs.model.MessageAttributeValue;

public class SqsMessage<T>
implements ContextAwareMessage<T>,
MetadataInjectableMessage<T> {
    private final Message message;
    private final SqsAckHandler ackHandler;
    private final T payload;
    private Metadata metadata;

    public SqsMessage(Message message, JsonMapping jsonMapper, SqsAckHandler ackHandler) {
        this.message = message;
        this.ackHandler = ackHandler;
        Map attributes = message.messageAttributes();
        if (attributes.containsKey("_classname")) {
            String cn = ((MessageAttributeValue)attributes.get("_classname")).stringValue();
            try {
                this.payload = this.convert(message.body(), jsonMapper, this.load(cn));
            }
            catch (ClassNotFoundException e) {
                throw AwsSqsExceptions.ex.illegalStateUnableToLoadClass(cn, e);
            }
        } else {
            this.payload = message.body();
        }
        this.metadata = ContextAwareMessage.captureContextMetadata((Object[])new Object[]{new SqsIncomingMetadata(message)});
    }

    private T convert(String value, JsonMapping jsonMapping, Class<T> clazz) {
        if (clazz.equals(Integer.class)) {
            return (T)Integer.valueOf(value);
        }
        if (clazz.equals(Long.class)) {
            return (T)Long.valueOf(value);
        }
        if (clazz.equals(Double.class)) {
            return (T)Double.valueOf(value);
        }
        if (clazz.equals(Float.class)) {
            return (T)Float.valueOf(value);
        }
        if (clazz.equals(Boolean.class)) {
            return (T)Boolean.valueOf(value);
        }
        if (clazz.equals(Short.class)) {
            return (T)Short.valueOf(value);
        }
        if (clazz.equals(Byte.class)) {
            return (T)Byte.valueOf(value);
        }
        if (clazz.equals(String.class)) {
            return (T)value;
        }
        return (T)jsonMapping.fromJson(value, clazz);
    }

    private Class<T> load(String cn) throws ClassNotFoundException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            try {
                return loader.loadClass(cn);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return SqsMessage.class.getClassLoader().loadClass(cn);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public T getPayload() {
        return this.payload;
    }

    public Message getMessage() {
        return this.message;
    }

    public CompletionStage<Void> ack(Metadata metadata) {
        return this.ackHandler.handle(this).subscribeAsCompletionStage();
    }

    public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
        return this::ack;
    }

    public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        CompletableFuture<Void> nack = new CompletableFuture<Void>();
        this.runOnMessageContext(() -> nack.complete(null));
        return nack;
    }

    public BiFunction<Throwable, Metadata, CompletionStage<Void>> getNackWithMetadata() {
        return this::nack;
    }

    public void injectMetadata(Object metadataObject) {
        this.metadata = this.metadata.with(metadataObject);
    }
}

