/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.camel;

import io.smallrye.reactive.messaging.camel.CamelFailureHandler;
import io.smallrye.reactive.messaging.camel.IncomingExchangeMetadata;
import java.util.concurrent.CompletionStage;
import org.apache.camel.Exchange;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class CamelMessage<T>
implements Message<T> {
    private final Exchange exchange;
    private final Metadata metadata;
    private final CamelFailureHandler onNack;

    public CamelMessage(Exchange exchange, CamelFailureHandler onNack) {
        this.exchange = exchange;
        this.onNack = onNack;
        this.metadata = Metadata.of((Object[])new Object[]{new IncomingExchangeMetadata(exchange)});
    }

    public T getPayload() {
        return (T)this.exchange.getIn().getBody();
    }

    public T getPayload(Class<T> clazz) {
        return (T)this.exchange.getIn().getBody(clazz);
    }

    public Exchange getExchange() {
        return this.exchange;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public CompletionStage<Void> nack(Throwable reason) {
        return this.onNack.handle(this, reason);
    }
}

