/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.cloudevents;

import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.fun.EventBuilder;
import io.cloudevents.v1.AttributesImpl;
import io.cloudevents.v1.CloudEventBuilder;
import io.cloudevents.v1.CloudEventImpl;
import io.smallrye.reactive.messaging.cloudevents.CloudEventMessage;
import io.smallrye.reactive.messaging.cloudevents.DefaultCloudEventMessage;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import org.eclipse.microprofile.reactive.messaging.Message;

public class CloudEventMessageBuilder<T>
implements EventBuilder<T, AttributesImpl> {
    private final CloudEventBuilder<T> builder = CloudEventBuilder.builder();

    public static <T> CloudEventMessageBuilder<T> from(Message<T> message) {
        CloudEventMessageBuilder<Object> builder = new CloudEventMessageBuilder<Object>();
        builder.withData(message.getPayload());
        if (message instanceof CloudEventMessage) {
            CloudEventMessage cem = (CloudEventMessage)message;
            builder.withId(((AttributesImpl)cem.getAttributes()).getId());
            builder.withType(((AttributesImpl)cem.getAttributes()).getType());
            builder.withSource(((AttributesImpl)cem.getAttributes()).getSource());
            ((AttributesImpl)cem.getAttributes()).getDatacontenttype().ifPresent(builder::withDataContentType);
            ((AttributesImpl)cem.getAttributes()).getDataschema().ifPresent(builder::withDataschema);
            ((AttributesImpl)cem.getAttributes()).getSubject().ifPresent(builder::withSubject);
            ((AttributesImpl)cem.getAttributes()).getTime().ifPresent(builder::withTime);
        }
        return builder;
    }

    public CloudEventMessageBuilder<T> withId(String id) {
        this.builder.withId(id);
        return this;
    }

    public CloudEventMessageBuilder<T> withSource(URI source) {
        this.builder.withSource(source);
        return this;
    }

    public CloudEventMessageBuilder<T> withType(String type) {
        this.builder.withType(type);
        return this;
    }

    public CloudEventMessageBuilder<T> withDataschema(URI dataschema) {
        this.builder.withDataschema(dataschema);
        return this;
    }

    public CloudEventMessageBuilder<T> withDataContentType(String datacontenttype) {
        this.builder.withDataContentType(datacontenttype);
        return this;
    }

    public CloudEventMessageBuilder<T> withSubject(String subject) {
        this.builder.withSubject(subject);
        return this;
    }

    public CloudEventMessageBuilder<T> withTime(ZonedDateTime time) {
        this.builder.withTime(time);
        return this;
    }

    public CloudEventMessageBuilder<T> withData(T data) {
        this.builder.withData(data);
        return this;
    }

    public CloudEventMessageBuilder<T> withExtension(ExtensionFormat extension) {
        this.builder.withExtension(extension);
        return this;
    }

    public CloudEventMessage<T> build() {
        return new DefaultCloudEventMessage(this.builder.build());
    }

    public CloudEventMessage<T> build(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions) {
        CloudEventBuilder builder = CloudEventBuilder.builder().withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withTime(arg_0));
        attributes.getDataschema().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withDataschema(arg_0));
        attributes.getDatacontenttype().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withDataContentType(arg_0));
        attributes.getSubject().ifPresent(arg_0 -> ((CloudEventBuilder)builder).withSubject(arg_0));
        extensions.forEach(arg_0 -> ((CloudEventBuilder)builder).withExtension(arg_0));
        CloudEventImpl event = builder.withData(data).build();
        return new DefaultCloudEventMessage(event);
    }
}

