/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.gcp.pubsub;

import io.smallrye.reactive.messaging.gcp.pubsub.i18n.PubSubMessages;
import java.nio.file.Path;
import java.util.Objects;

public class PubSubConfig {
    private final String projectId;
    private final String topic;
    private final Path credentialPath;
    private final String subscription;
    private final boolean mockPubSubTopics;
    private final String host;
    private final Integer port;

    public PubSubConfig(String projectId, String topic, Path credentialPath, boolean mockPubSubTopics, String host, Integer port) {
        this.projectId = Objects.requireNonNull(projectId, PubSubMessages.msg.mustNotBeNull("projectId"));
        this.topic = Objects.requireNonNull(topic, PubSubMessages.msg.mustNotBeNull("topic"));
        this.credentialPath = credentialPath;
        this.subscription = null;
        this.mockPubSubTopics = mockPubSubTopics;
        this.host = host;
        this.port = port;
    }

    public PubSubConfig(String projectId, String topic, Path credentialPath, String subscription, boolean mockPubSubTopics, String host, Integer port) {
        this.projectId = Objects.requireNonNull(projectId, PubSubMessages.msg.mustNotBeNull("projectId"));
        this.topic = Objects.requireNonNull(topic, PubSubMessages.msg.mustNotBeNull("topic"));
        this.credentialPath = credentialPath;
        this.subscription = subscription;
        this.mockPubSubTopics = mockPubSubTopics;
        this.host = host;
        this.port = port;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getTopic() {
        return this.topic;
    }

    public Path getCredentialPath() {
        return this.credentialPath;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public boolean isMockPubSubTopics() {
        return this.mockPubSubTopics;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PubSubConfig that = (PubSubConfig)o;
        return Objects.equals(this.projectId, that.projectId) && Objects.equals(this.topic, that.topic) && Objects.equals(this.credentialPath, that.credentialPath) && Objects.equals(this.subscription, that.subscription) && this.mockPubSubTopics == that.mockPubSubTopics && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port);
    }

    public int hashCode() {
        return Objects.hash(this.projectId, this.topic, this.credentialPath, this.subscription, this.mockPubSubTopics, this.host, this.port);
    }

    public String toString() {
        return "PubSubConfig[projectId=" + this.projectId + ", topic=" + this.topic + ", credentialPath=" + this.credentialPath + ", subscription=" + this.subscription + ", mockPubSubTopics=" + this.mockPubSubTopics + ", host=" + this.host + ", port=" + this.port + "]";
    }
}

