/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.gcp.pubsub;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.pubsub.v1.PubsubMessage;
import io.smallrye.reactive.messaging.gcp.pubsub.i18n.PubSubMessages;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public class PubSubMessage
implements Message<String> {
    private final PubsubMessage message;
    private final AckReplyConsumer ackReplyConsumer;

    public PubSubMessage(PubsubMessage message) {
        this.message = Objects.requireNonNull(message, PubSubMessages.msg.isRequired("message"));
        this.ackReplyConsumer = null;
    }

    public PubSubMessage(PubsubMessage message, AckReplyConsumer ackReplyConsumer) {
        this.message = Objects.requireNonNull(message, PubSubMessages.msg.isRequired("message"));
        this.ackReplyConsumer = Objects.requireNonNull(ackReplyConsumer, PubSubMessages.msg.isRequired("ackReplyConsumer"));
    }

    public PubsubMessage getMessage() {
        return this.message;
    }

    public String getPayload() {
        return this.message.getData().toStringUtf8();
    }

    public CompletionStage<Void> ack(Metadata metadata) {
        if (this.ackReplyConsumer != null) {
            this.ackReplyConsumer.ack();
        }
        return CompletableFuture.completedFuture(null);
    }

    public Function<Metadata, CompletionStage<Void>> getAckWithMetadata() {
        return this::ack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PubSubMessage that = (PubSubMessage)o;
        return Objects.equals(this.message, that.message);
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public String toString() {
        return "PubSubMessage[message=" + this.message + "]";
    }
}

