/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.gcp.pubsub;

import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.pubsub.v1.PubsubMessage;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.smallrye.reactive.messaging.gcp.pubsub.PubSubMessage;
import io.smallrye.reactive.messaging.gcp.pubsub.i18n.PubSubLogging;
import io.smallrye.reactive.messaging.gcp.pubsub.i18n.PubSubMessages;
import java.util.Objects;
import org.eclipse.microprofile.reactive.messaging.Message;

public class PubSubMessageReceiver
implements MessageReceiver {
    private final MultiEmitter<? super Message<?>> emitter;

    public PubSubMessageReceiver(MultiEmitter<? super Message<?>> emitter) {
        this.emitter = Objects.requireNonNull(emitter, PubSubMessages.msg.isRequired("emitter"));
    }

    public void receiveMessage(PubsubMessage message, AckReplyConsumer ackReplyConsumer) {
        PubSubLogging.log.receivedMessage(message);
        this.emitter.emit((Object)new PubSubMessage(message, ackReplyConsumer));
    }
}

