package io.smallrye.reactive.messaging.memory;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;

/**
 * Extract the incoming configuration for the {@code smallrye-in-memory} connector.
*/
public class InMemoryConnectorIncomingConfiguration extends InMemoryConnectorCommonConfiguration {

  /**
   * Creates a new InMemoryConnectorIncomingConfiguration.
   */
  public InMemoryConnectorIncomingConfiguration(Config config) {
    super(config);
    validate();
  }

  /**
  * Gets the run-on-vertx-context value from the configuration.
  * Attribute Name: run-on-vertx-context
  * Description: Whether messages are dispatched on the Vert.x context or not.
  * Default Value: false
  * @return the run-on-vertx-context
  */
  public Boolean getRunOnVertxContext() {
    return config.getOptionalValue("run-on-vertx-context", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  /**
  * Gets the broadcast value from the configuration.
  * Attribute Name: broadcast
  * Description: Whether the messages are dispatched to multiple consumer
  * Default Value: false
  * @return the broadcast
  */
  public Boolean getBroadcast() {
    return config.getOptionalValue("broadcast", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  public void validate() {
    super.validate();
  }
}
