package io.smallrye.reactive.messaging.jms;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;

/**
 * Extract the incoming configuration for the {@code smallrye-jms} connector.
*/
public class JmsConnectorIncomingConfiguration extends JmsConnectorCommonConfiguration {

  /**
   * Creates a new JmsConnectorIncomingConfiguration.
   */
  public JmsConnectorIncomingConfiguration(Config config) {
    super(config);
    validate();
  }

  /**
  * Gets the selector value from the configuration.
  * Attribute Name: selector
  * Description: The JMS selector
  * @return the selector
  */
  public Optional<String> getSelector() {
    return config.getOptionalValue("selector", String.class);
  }

  /**
  * Gets the no-local value from the configuration.
  * Attribute Name: no-local
  * Description: Enable or disable local delivery
  * Default Value: false
  * @return the no-local
  */
  public Boolean getNoLocal() {
    return config.getOptionalValue("no-local", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  /**
  * Gets the broadcast value from the configuration.
  * Attribute Name: broadcast
  * Description: Whether or not the JMS message should be dispatched to multiple consumers
  * Default Value: false
  * @return the broadcast
  */
  public Boolean getBroadcast() {
    return config.getOptionalValue("broadcast", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  /**
  * Gets the durable value from the configuration.
  * Attribute Name: durable
  * Description: Set to `true` to use a durable subscription
  * Default Value: false
  * @return the durable
  */
  public Boolean getDurable() {
    return config.getOptionalValue("durable", Boolean.class)
     .orElse(Boolean.valueOf("false"));
  }

  public void validate() {
    super.validate();
  }
}
