package io.smallrye.reactive.messaging.jms.i18n;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class JmsLogging_$logger extends DelegatingBasicLogger implements JmsLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JmsLogging_$logger.class.getName();
    public JmsLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void unableToSend(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToSend$str());
    }
    protected String unableToSend$str() {
        return "SRMSG15800: Unable to send message to JMS";
    }
    @Override
    public final void creatingQueue(final String name) {
        super.log.logf(FQCN, INFO, null, creatingQueue$str(), name);
    }
    protected String creatingQueue$str() {
        return "SRMSG15801: Creating queue %s";
    }
    @Override
    public final void creatingTopic(final String name) {
        super.log.logf(FQCN, INFO, null, creatingTopic$str(), name);
    }
    protected String creatingTopic$str() {
        return "SRMSG15802: Creating topic %s";
    }
    @Override
    public final void clientClosed() {
        super.log.logf(FQCN, WARN, null, clientClosed$str());
    }
    protected String clientClosed$str() {
        return "SRMSG15803: Unable to receive JMS messages - client has been closed";
    }
}
