/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms;

import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class JmsConnectorCommonConfiguration {
    protected final Config config;

    public JmsConnectorCommonConfiguration(Config config) {
        this.config = config;
    }

    public Config config() {
        return this.config;
    }

    protected <T> Optional<T> getFromAlias(String alias, Class<T> type) {
        return ConfigProvider.getConfig().getOptionalValue(alias, type);
    }

    protected <T> T getFromAliasWithDefaultValue(String alias, Class<T> type, T defaultValue) {
        return this.getFromAlias(alias, type).orElse(defaultValue);
    }

    public String getChannel() {
        return (String)this.config.getValue("channel-name", String.class);
    }

    public Optional<String> getConnectionFactoryName() {
        return this.config.getOptionalValue("connection-factory-name", String.class);
    }

    public Optional<String> getUsername() {
        return this.config.getOptionalValue("username", String.class);
    }

    public Optional<String> getPassword() {
        return this.config.getOptionalValue("password", String.class);
    }

    public String getSessionMode() {
        return this.config.getOptionalValue("session-mode", String.class).orElse("AUTO_ACKNOWLEDGE");
    }

    public Optional<String> getClientId() {
        return this.config.getOptionalValue("client-id", String.class);
    }

    public Optional<String> getDestination() {
        return this.config.getOptionalValue("destination", String.class);
    }

    public String getDestinationType() {
        return this.config.getOptionalValue("destination-type", String.class).orElse("queue");
    }

    public void validate() {
    }
}

