/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms.i18n;

import io.smallrye.reactive.messaging.jms.i18n.JmsExceptions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;

public class JmsExceptions_$bundle
implements JmsExceptions,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final JmsExceptions_$bundle INSTANCE = new JmsExceptions_$bundle();
    private static final Locale LOCALE = Locale.ROOT;

    protected JmsExceptions_$bundle() {
    }

    protected Object readResolve() {
        return INSTANCE;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String illegalStateUnableToLoadClass$str() {
        return "SRMSG15600: Unable to load the class";
    }

    @Override
    public final IllegalArgumentException illegalStateUnableToLoadClass(Throwable t) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalStateUnableToLoadClass$str(), new Object[0]), t);
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String illegalStateUnableToUnwrap$str() {
        return "SRMSG15601: Unable to unwrap message to %s";
    }

    @Override
    public final IllegalArgumentException illegalStateUnableToUnwrap(Class unwrapType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalStateUnableToUnwrap$str(), unwrapType));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateCannotFindFactory$str() {
        return "SRMSG15602: Cannot find a javax.jms.ConnectionFactory bean";
    }

    @Override
    public final IllegalStateException illegalStateCannotFindFactory() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateCannotFindFactory$str(), new Object[0]));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateCannotFindNamedFactory$str() {
        return "SRMSG15603: Cannot find a javax.jms.ConnectionFactory bean named %s";
    }

    @Override
    public final IllegalStateException illegalStateCannotFindNamedFactory(String factoryName) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateCannotFindNamedFactory$str(), factoryName));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateUnknowSessionMode$str() {
        return "SRMSG15604: Unknown session mode: %s";
    }

    @Override
    public final IllegalArgumentException illegalStateUnknowSessionMode(String mode) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalStateUnknowSessionMode$str(), mode));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateKeyNull$str() {
        return "SRMSG15605: The key must not be `null` or blank";
    }

    @Override
    public final IllegalArgumentException illegalStateKeyNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalStateKeyNull$str(), new Object[0]));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateValueNull$str() {
        return "SRMSG15606: The value must not be `null`";
    }

    @Override
    public final IllegalArgumentException illegalStateValueNull() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalStateValueNull$str(), new Object[0]));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentInvalidDeliveryMode$str() {
        return "SRMSG15607: Invalid delivery mode, it should be either `persistent` or `non_persistent`: %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentInvalidDeliveryMode(String v) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentInvalidDeliveryMode$str(), v));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentInvalidDestinationType$str() {
        return "SRMSG15608: Invalid destination type, it should be either `queue` or `topic`: %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentInvalidDestinationType(String replyToDestinationType) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentInvalidDestinationType$str(), replyToDestinationType));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateUnableToMapProperties$str() {
        return "SRMSG15609: Unable to map JMS properties to the outgoing message, OutgoingJmsProperties expected, found %s";
    }

    @Override
    public final IllegalStateException illegalStateUnableToMapProperties(String name) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateUnableToMapProperties$str(), name));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateUnknownDestinationType$str() {
        return "SRMSG15610: Unknown destination type: %s";
    }

    @Override
    public final IllegalStateException illegalStateUnknownDestinationType(String type) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateUnknownDestinationType$str(), type));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentInvalidDestination$str() {
        return "SRMSG15611: Invalid destination, only topic can be durable";
    }

    @Override
    public final IllegalArgumentException illegalArgumentInvalidDestination() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentInvalidDestination$str(), new Object[0]));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalArgumentUnknownDestinationType$str() {
        return "SRMSG15612: Unknown destination type: %s";
    }

    @Override
    public final IllegalArgumentException illegalArgumentUnknownDestinationType(String type) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgumentUnknownDestinationType$str(), type));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }

    protected String illegalStateAlreadySubscriber$str() {
        return "SRMSG15613: There is already a subscriber";
    }

    @Override
    public final IllegalStateException illegalStateAlreadySubscriber() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.illegalStateAlreadySubscriber$str(), new Object[0]));
        JmsExceptions_$bundle._copyStackTraceMinusOne(result);
        return result;
    }
}

