/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms.impl;

import io.smallrye.reactive.messaging.jms.JmsProperties;
import io.smallrye.reactive.messaging.jms.impl.Wrap;
import jakarta.jms.Message;
import java.util.Enumeration;

public final class ImmutableJmsProperties
implements JmsProperties {
    private final Message delegate;

    public ImmutableJmsProperties(Message message) {
        this.delegate = message;
    }

    @Override
    public boolean propertyExists(String name) {
        return Wrap.wrap(() -> this.delegate.propertyExists(name));
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return Wrap.wrap(() -> this.delegate.getBooleanProperty(name));
    }

    @Override
    public byte getByteProperty(String name) {
        return Wrap.wrap(() -> this.delegate.getByteProperty(name));
    }

    @Override
    public short getShortProperty(String name) {
        return Wrap.wrap(() -> this.delegate.getShortProperty(name));
    }

    @Override
    public int getIntProperty(String name) {
        return Wrap.wrap(() -> this.delegate.getIntProperty(name));
    }

    @Override
    public long getLongProperty(String name) {
        return Wrap.wrap(() -> this.delegate.getLongProperty(name));
    }

    @Override
    public float getFloatProperty(String name) {
        return Wrap.wrap(() -> Float.valueOf(this.delegate.getFloatProperty(name))).floatValue();
    }

    @Override
    public double getDoubleProperty(String name) {
        return Wrap.wrap(() -> this.delegate.getDoubleProperty(name));
    }

    @Override
    public String getStringProperty(String name) {
        return Wrap.wrap(() -> this.delegate.getStringProperty(name));
    }

    @Override
    public Object getObjectProperty(String name) {
        return Wrap.wrap(() -> this.delegate.getObjectProperty(name));
    }

    @Override
    public Enumeration<String> getPropertyNames() {
        return Wrap.wrap(() -> ((Message)this.delegate).getPropertyNames());
    }
}

