/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.jms.tracing;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.smallrye.reactive.messaging.jms.tracing.JmsTrace;
import java.util.Collections;
import java.util.List;

public class JmsAttributesExtractor
implements AttributesExtractor<JmsTrace, Void> {
    private final MessagingAttributesGetter<JmsTrace, Void> messagingAttributesGetter = new JmsMessagingAttributesGetter();

    public void onStart(AttributesBuilder attributes, Context parentContext, JmsTrace jmsTrace) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, JmsTrace jmsTrace, Void unused, Throwable error) {
    }

    public MessagingAttributesGetter<JmsTrace, Void> getMessagingAttributesGetter() {
        return this.messagingAttributesGetter;
    }

    private static final class JmsMessagingAttributesGetter
    implements MessagingAttributesGetter<JmsTrace, Void> {
        private JmsMessagingAttributesGetter() {
        }

        public String getSystem(JmsTrace jmsTrace) {
            return "jms";
        }

        public String getDestination(JmsTrace jmsTrace) {
            return jmsTrace.getQueue();
        }

        public boolean isTemporaryDestination(JmsTrace jmsTrace) {
            return false;
        }

        public String getConversationId(JmsTrace jmsTrace) {
            return null;
        }

        public String getMessageId(JmsTrace jmsTrace, Void unused) {
            return null;
        }

        public List<String> getMessageHeader(JmsTrace jmsTrace, String name) {
            return Collections.emptyList();
        }

        public String getDestinationTemplate(JmsTrace jmsTrace) {
            return null;
        }

        public boolean isAnonymousDestination(JmsTrace jmsTrace) {
            return false;
        }

        public Long getMessageBodySize(JmsTrace jmsTrace) {
            return null;
        }

        public Long getMessageEnvelopeSize(JmsTrace jmsTrace) {
            return null;
        }

        public String getClientId(JmsTrace jmsTrace) {
            return null;
        }

        public Long getBatchMessageCount(JmsTrace jmsTrace, Void unused) {
            return null;
        }
    }
}

